/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import java.util.List;

public class StaticServiceSelector
implements ServiceSelector {
    private final String type;
    private final String pool;
    private final List<ServiceDescriptor> serviceDescriptors;

    public StaticServiceSelector(ServiceDescriptor ... serviceDescriptors) {
        this((Iterable<ServiceDescriptor>)ImmutableList.copyOf((Object[])serviceDescriptors));
    }

    public StaticServiceSelector(Iterable<ServiceDescriptor> serviceDescriptors) {
        Preconditions.checkNotNull(serviceDescriptors, (Object)"serviceDescriptors is null");
        ServiceDescriptor serviceDescriptor = (ServiceDescriptor)Iterables.getFirst(serviceDescriptors, null);
        if (serviceDescriptor != null) {
            this.type = serviceDescriptor.getType();
            this.pool = serviceDescriptor.getPool();
        } else {
            this.type = "unknown";
            this.pool = "general";
        }
        for (ServiceDescriptor descriptor : serviceDescriptors) {
            Preconditions.checkArgument((boolean)descriptor.getType().equals(this.type));
            Preconditions.checkArgument((boolean)descriptor.getPool().equals(this.pool));
        }
        this.serviceDescriptors = ImmutableList.copyOf(serviceDescriptors);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public List<ServiceDescriptor> selectAllServices() {
        return this.serviceDescriptors;
    }
}

