/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import io.airlift.http.client.jetty.JettyIoPoolConfig;
import java.io.Closeable;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class JettyIoPool
implements Closeable {
    private final String name;
    private final QueuedThreadPool executor;
    private final ByteBufferPool byteBufferPool;
    private final Scheduler scheduler;

    public JettyIoPool(String name, JettyIoPoolConfig config) {
        this.name = name;
        try {
            QueuedThreadPool threadPool = new QueuedThreadPool(config.getMaxThreads(), config.getMinThreads());
            threadPool.setName("http-client-" + name);
            threadPool.setDaemon(true);
            threadPool.start();
            threadPool.setStopTimeout(2000L);
            this.executor = threadPool;
            this.scheduler = new ScheduledExecutorScheduler("http-client-" + name + "-scheduler", true);
            this.scheduler.start();
            this.byteBufferPool = new MappedByteBufferPool();
        }
        catch (Exception e) {
            this.close();
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            JettyIoPool.closeQuietly((LifeCycle)this.executor);
        }
        finally {
            JettyIoPool.closeQuietly((LifeCycle)this.scheduler);
        }
    }

    private static void closeQuietly(LifeCycle service) {
        try {
            if (service != null) {
                service.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ByteBufferPool setByteBufferPool() {
        return this.byteBufferPool;
    }

    public Scheduler setScheduler() {
        return this.scheduler;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }
}

