/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.airlift.slice.AbstractSliceInputTest;
import io.airlift.slice.ChunkedSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestChunkedSliceInput
extends AbstractSliceInputTest {
    @Override
    protected SliceInput createSliceInput(Slice slice) {
        return new ChunkedSliceInput((ChunkedSliceInput.SliceLoader)new SliceSliceLoader(slice), 129);
    }

    @Test
    public void testSetPosition() {
        int length = 160;
        int bufferSize = 130;
        Slice slice = Slices.utf8Slice((String)Strings.repeat((String)"0", (int)length));
        SliceSliceLoader loader = new SliceSliceLoader(slice);
        ChunkedSliceInput chunkedSliceInput = new ChunkedSliceInput((ChunkedSliceInput.SliceLoader)loader, bufferSize);
        ArrayList<Integer> actual = new ArrayList<Integer>();
        for (int i2 = 0; i2 < length; ++i2) {
            chunkedSliceInput.setPosition((long)i2);
            chunkedSliceInput.readByte();
            int count = loader.getCount();
            actual.add(count);
        }
        List expected = IntStream.range(0, length).map(i -> i < bufferSize ? 1 : 2).boxed().collect(Collectors.toList());
        Assert.assertEquals(actual, expected);
    }

    private static class SliceSliceLoader
    implements ChunkedSliceInput.SliceLoader<ChunkedSliceInput.BufferReference> {
        private final Slice data;
        private final AtomicInteger count = new AtomicInteger(0);

        public SliceSliceLoader(Slice data) {
            this.data = data;
        }

        public ChunkedSliceInput.BufferReference createBuffer(int bufferSize) {
            final Slice slice = Slices.allocate((int)bufferSize);
            return new ChunkedSliceInput.BufferReference(){

                public Slice getSlice() {
                    return slice;
                }
            };
        }

        public long getSize() {
            return this.data.length();
        }

        public void load(long position, ChunkedSliceInput.BufferReference buffer, int length) {
            Preconditions.checkPositionIndex((int)((int)(position + (long)length)), (int)((int)this.getSize()));
            this.count.incrementAndGet();
            this.data.getBytes((int)position, buffer.getSlice(), 0, length);
        }

        public int getCount() {
            return this.count.get();
        }

        public void close() {
        }
    }
}

