/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.AbstractSliceInputTest;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInputStreamSliceInput
extends AbstractSliceInputTest {
    @Override
    protected SliceInput createSliceInput(Slice slice) {
        return this.buildSliceInput(slice.getBytes());
    }

    @Override
    protected void testReadReverse(AbstractSliceInputTest.SliceInputTester tester, Slice slice) {
    }

    @Test
    public void testEmptyInput() throws Exception {
        SliceInput input = this.buildSliceInput(new byte[0]);
        Assert.assertEquals((long)input.position(), (long)0L);
    }

    @Test
    public void testEmptyRead() throws Exception {
        SliceInput input = this.buildSliceInput(new byte[0]);
        Assert.assertEquals((int)input.read(), (int)-1);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadByteBeyondEnd() throws Exception {
        SliceInput input = this.buildSliceInput(new byte[0]);
        input.readByte();
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadShortBeyondEnd() throws Exception {
        SliceInput input = this.buildSliceInput(new byte[1]);
        input.readShort();
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadIntBeyondEnd() throws Exception {
        SliceInput input = this.buildSliceInput(new byte[3]);
        input.readInt();
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadLongBeyondEnd() throws Exception {
        SliceInput input = this.buildSliceInput(new byte[7]);
        input.readLong();
    }

    @Test
    public void testEncodingBoolean() throws Exception {
        Assert.assertEquals((boolean)this.buildSliceInput(new byte[]{1}).readBoolean(), (boolean)true);
        Assert.assertEquals((boolean)this.buildSliceInput(new byte[]{0}).readBoolean(), (boolean)false);
    }

    @Test
    public void testEncodingByte() throws Exception {
        Assert.assertEquals((int)this.buildSliceInput(new byte[]{92}).readByte(), (int)92);
        Assert.assertEquals((int)this.buildSliceInput(new byte[]{-100}).readByte(), (int)-100);
        Assert.assertEquals((int)this.buildSliceInput(new byte[]{-17}).readByte(), (int)-17);
        Assert.assertEquals((int)this.buildSliceInput(new byte[]{92}).readUnsignedByte(), (int)92);
        Assert.assertEquals((int)this.buildSliceInput(new byte[]{-100}).readUnsignedByte(), (int)156);
        Assert.assertEquals((int)this.buildSliceInput(new byte[]{-17}).readUnsignedByte(), (int)239);
    }

    @Test
    public void testEncodingShort() throws Exception {
        Assert.assertEquals((int)this.buildSliceInput(new byte[]{109, 92}).readShort(), (int)23661);
        Assert.assertEquals((int)this.buildSliceInput(new byte[]{109, -100}).readShort(), (int)-25491);
        Assert.assertEquals((int)this.buildSliceInput(new byte[]{-52, -107}).readShort(), (int)-27188);
        Assert.assertEquals((int)this.buildSliceInput(new byte[]{109, -100}).readUnsignedShort(), (int)40045);
        Assert.assertEquals((int)this.buildSliceInput(new byte[]{-52, -107}).readUnsignedShort(), (int)38348);
    }

    @Test
    public void testEncodingInteger() throws Exception {
        Assert.assertEquals((int)this.buildSliceInput(new byte[]{109, 92, 75, 58}).readInt(), (int)978017389);
        Assert.assertEquals((int)this.buildSliceInput(new byte[]{-16, -60, -120, -1}).readInt(), (int)-7813904);
    }

    @Test
    public void testEncodingLong() throws Exception {
        Assert.assertEquals((long)this.buildSliceInput(new byte[]{49, -114, -96, -23, -32, -96, -32, 127}).readLong(), (long)9214541725452766769L);
        Assert.assertEquals((long)this.buildSliceInput(new byte[]{109, 92, 75, 58, 18, 120, -112, -17}).readLong(), (long)-1184314682315678611L);
    }

    @Test
    public void testEncodingDouble() throws Exception {
        Assert.assertEquals((Object)this.buildSliceInput(new byte[]{31, -123, -21, 81, -72, 30, 9, 64}).readDouble(), (Object)3.14);
        Assert.assertEquals((Object)this.buildSliceInput(new byte[]{0, 0, 0, 0, 0, 0, -8, 127}).readDouble(), (Object)Double.NaN);
        Assert.assertEquals((Object)this.buildSliceInput(new byte[]{0, 0, 0, 0, 0, 0, -16, -1}).readDouble(), (Object)Double.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)this.buildSliceInput(new byte[]{0, 0, 0, 0, 0, 0, -16, 127}).readDouble(), (Object)Double.POSITIVE_INFINITY);
    }

    @Test
    public void testEncodingFloat() throws Exception {
        Assert.assertEquals((Object)Float.valueOf(this.buildSliceInput(new byte[]{-61, -11, 72, 64}).readFloat()), (Object)Float.valueOf(3.14f));
        Assert.assertEquals((Object)Float.valueOf(this.buildSliceInput(new byte[]{0, 0, -64, 127}).readFloat()), (Object)Float.valueOf(Float.NaN));
        Assert.assertEquals((Object)Float.valueOf(this.buildSliceInput(new byte[]{0, 0, -128, -1}).readFloat()), (Object)Float.valueOf(Float.NEGATIVE_INFINITY));
        Assert.assertEquals((Object)Float.valueOf(this.buildSliceInput(new byte[]{0, 0, -128, 127}).readFloat()), (Object)Float.valueOf(Float.POSITIVE_INFINITY));
    }

    private SliceInput buildSliceInput(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return new InputStreamSliceInput((InputStream)inputStream, 16384);
    }
}

