/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOutputStreamSliceOutput {
    @Test
    public void testEncodingBoolean() throws Exception {
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeBoolean(true), 1);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeBoolean(false), 0);
    }

    @Test
    public void testEncodingByte() throws Exception {
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeByte(92), 92);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeByte(156), -100);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeByte(-17), -17);
    }

    @Test
    public void testEncodingShort() throws Exception {
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeShort(23661), 109, 92);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeShort(40045), 109, -100);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeShort(-27188), -52, -107);
    }

    @Test
    public void testEncodingInteger() throws Exception {
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeInt(978017389), 109, 92, 75, 58);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeInt(-7813904), -16, -60, -120, -1);
    }

    @Test
    public void testEncodingLong() throws Exception {
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeLong(9214541725452766769L), 49, -114, -96, -23, -32, -96, -32, 127);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeLong(-1184314682315678611L), 109, 92, 75, 58, 18, 120, -112, -17);
    }

    @Test
    public void testEncodingDouble() throws Exception {
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeDouble(3.14), 31, -123, -21, 81, -72, 30, 9, 64);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeDouble(Double.NaN), 0, 0, 0, 0, 0, 0, -8, 127);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeDouble(Double.NEGATIVE_INFINITY), 0, 0, 0, 0, 0, 0, -16, -1);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeDouble(Double.POSITIVE_INFINITY), 0, 0, 0, 0, 0, 0, -16, 127);
    }

    @Test
    public void testEncodingFloat() throws Exception {
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeFloat(3.14f), -61, -11, 72, 64);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeFloat(Float.NaN), 0, 0, -64, 127);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeFloat(Float.NEGATIVE_INFINITY), 0, 0, -128, -1);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeFloat(Float.POSITIVE_INFINITY), 0, 0, -128, 127);
    }

    @Test
    public void testEncodingBytes() throws Exception {
        byte[] data = new byte[18000];
        ThreadLocalRandom.current().nextBytes(data);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.write(data, 0, 0), Arrays.copyOfRange(data, 0, 0));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.write(data, 0, 3), Arrays.copyOfRange(data, 0, 3));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.write(data, 0, 370), Arrays.copyOfRange(data, 0, 370));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.write(data, 0, 4095), Arrays.copyOfRange(data, 0, 4095));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.write(data, 0, 4096), Arrays.copyOfRange(data, 0, 4096));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.write(data, 0, 12348), Arrays.copyOfRange(data, 0, 12348));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.write(data, 0, 16384), Arrays.copyOfRange(data, 0, 16384));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.write(data, 0, 18000), Arrays.copyOfRange(data, 0, 18000));
    }

    @Test
    public void testEncodingSlice() throws Exception {
        byte[] data = new byte[18000];
        ThreadLocalRandom.current().nextBytes(data);
        Slice slice = Slices.wrappedBuffer((byte[])data);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeBytes(slice, 0, 0), Arrays.copyOfRange(data, 0, 0));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeBytes(slice, 0, 3), Arrays.copyOfRange(data, 0, 3));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeBytes(slice, 0, 370), Arrays.copyOfRange(data, 0, 370));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeBytes(slice, 0, 4095), Arrays.copyOfRange(data, 0, 4095));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeBytes(slice, 0, 4096), Arrays.copyOfRange(data, 0, 4096));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeBytes(slice, 0, 12348), Arrays.copyOfRange(data, 0, 12348));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeBytes(slice, 0, 16384), Arrays.copyOfRange(data, 0, 16384));
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeBytes(slice, 0, 18000), Arrays.copyOfRange(data, 0, 18000));
    }

    @Test
    public void testWriteZero() throws Exception {
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(0), new byte[0]);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(1), new byte[1]);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(2), new byte[2]);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(3), new byte[3]);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(4), new byte[4]);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(6), new byte[6]);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(7), new byte[7]);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(8), new byte[8]);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(9), new byte[9]);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(16), new byte[16]);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(22), new byte[22]);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(227), new byte[227]);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(4227), new byte[4227]);
        this.assertEncoding((SliceOutput sliceOutput) -> sliceOutput.writeZero(18349), new byte[18349]);
    }

    private void assertEncoding(Consumer<SliceOutput> operations, byte ... expected) throws IOException {
        this.assertEncoding(operations, 0, expected);
        this.assertEncoding(operations, 1, expected);
        this.assertEncoding(operations, 2, expected);
        this.assertEncoding(operations, 3, expected);
        this.assertEncoding(operations, 4, expected);
        this.assertEncoding(operations, 7, expected);
        this.assertEncoding(operations, 8, expected);
        this.assertEncoding(operations, 16, expected);
        this.assertEncoding(operations, 511, expected);
        this.assertEncoding(operations, 12000, expected);
        this.assertEncoding(operations, 13000, expected);
        this.assertEncoding(operations, 16000, expected);
        this.assertEncoding(operations, 16380, expected);
        this.assertEncoding(operations, 16383, expected);
        this.assertEncoding(operations, 16384, expected);
        this.assertEncoding(operations, 18349, expected);
    }

    private void assertEncoding(Consumer<SliceOutput> operations, int offset, byte ... output) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (OutputStreamSliceOutput sliceOutput = new OutputStreamSliceOutput((OutputStream)byteArrayOutputStream, 16384);){
            sliceOutput.writeZero(offset);
            operations.accept((SliceOutput)sliceOutput);
            Assert.assertEquals((int)sliceOutput.size(), (int)(offset + output.length));
        }
        byte[] expected = new byte[offset + output.length];
        System.arraycopy(output, 0, expected, offset, output.length);
        Assert.assertEquals((byte[])byteArrayOutputStream.toByteArray(), (byte[])expected);
    }
}

