/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSliceOutput {
    @Test
    public void testAppendByte() throws Exception {
        for (int i = -128; i <= 127; ++i) {
            Slice actual = new DynamicSliceOutput(1).appendByte(i).slice();
            Slice expected = Slices.wrappedBuffer((byte[])new byte[]{(byte)i});
            Assert.assertEquals((Object)actual, (Object)expected);
        }
    }

    @Test
    public void testAppendUnsignedByte() throws Exception {
        for (int i = 0; i < 256; ++i) {
            Slice actual = new DynamicSliceOutput(1).appendByte(i).slice();
            Slice expected = Slices.wrappedBuffer((byte[])new byte[]{(byte)i});
            Assert.assertEquals((Object)actual, (Object)expected);
        }
    }

    @Test
    public void testAppendByteTruncation() throws Exception {
        for (int i = 256; i < 512; ++i) {
            Slice actual = new DynamicSliceOutput(1).appendByte(i).slice();
            Slice expected = Slices.wrappedBuffer((byte[])new byte[]{(byte)i});
            Assert.assertEquals((Object)actual, (Object)expected);
        }
    }

    @Test
    public void testAppendMultiple() throws Exception {
        Slice actual = new DynamicSliceOutput(1).appendByte(0).appendByte(1).appendByte(2).appendByte(3).appendByte(4).slice();
        Slice expected = Slices.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4});
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testRetainedSize() throws Exception {
        int sliceOutputInstanceSize = ClassLayout.parseClass(DynamicSliceOutput.class).instanceSize();
        DynamicSliceOutput output = new DynamicSliceOutput(10);
        long originalRetainedSize = output.getRetainedSize();
        Assert.assertEquals((long)originalRetainedSize, (long)((long)sliceOutputInstanceSize + output.getUnderlyingSlice().getRetainedSize()));
        Assert.assertEquals((int)output.size(), (int)0);
        output.appendLong(0L);
        output.appendShort(0);
        Assert.assertEquals((long)output.getRetainedSize(), (long)originalRetainedSize);
        Assert.assertEquals((int)output.size(), (int)10);
    }

    @Test
    public void testReset() throws Exception {
        TestSliceOutput.assertReset((SliceOutput)new DynamicSliceOutput(1));
        TestSliceOutput.assertReset(Slices.allocate((int)50).getOutput());
    }

    private static void assertReset(SliceOutput output) {
        output.appendByte(0).appendByte(1).appendByte(2).appendByte(3).appendByte(4);
        Assert.assertEquals((Object)output.slice(), (Object)Slices.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4}));
        output.reset();
        Assert.assertEquals((Object)output.slice(), (Object)Slices.EMPTY_SLICE);
        output.appendByte(2).appendByte(4).appendByte(6).appendByte(8).appendByte(10);
        Assert.assertEquals((Object)output.slice(), (Object)Slices.wrappedBuffer((byte[])new byte[]{2, 4, 6, 8, 10}));
        output.reset(5);
        Assert.assertEquals((Object)output.slice(), (Object)Slices.wrappedBuffer((byte[])new byte[]{2, 4, 6, 8, 10}));
        output.reset(3);
        Assert.assertEquals((Object)output.slice(), (Object)Slices.wrappedBuffer((byte[])new byte[]{2, 4, 6}));
        output.reset(1);
        Assert.assertEquals((Object)output.slice(), (Object)Slices.wrappedBuffer((byte[])new byte[]{2}));
        output.reset(0);
        Assert.assertEquals((Object)output.slice(), (Object)Slices.EMPTY_SLICE);
    }
}

