/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestXxHash64 {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final long PRIME = 2654435761L;
    private final Slice buffer = Slices.allocate((int)101);

    public TestXxHash64() {
        long value = 2654435761L;
        for (int i = 0; i < this.buffer.length(); ++i) {
            this.buffer.setByte(i, (int)((byte)(value >> 24)));
            value *= value;
        }
    }

    @Test
    public void testSanity() throws Exception {
        TestXxHash64.assertHash(0L, this.buffer, 1, 5750596776143442648L);
        TestXxHash64.assertHash(2654435761L, this.buffer, 1, 8329478753618994979L);
        TestXxHash64.assertHash(0L, this.buffer, 4, -7901876112562082063L);
        TestXxHash64.assertHash(2654435761L, this.buffer, 4, 708753852729961291L);
        TestXxHash64.assertHash(0L, this.buffer, 8, -626931337744172849L);
        TestXxHash64.assertHash(2654435761L, this.buffer, 8, -7186417346120842555L);
        TestXxHash64.assertHash(0L, this.buffer, 14, -3460297540090709443L);
        TestXxHash64.assertHash(2654435761L, this.buffer, 14, 6599481375206459851L);
        TestXxHash64.assertHash(0L, this.buffer, 32, -5812084625956540946L);
        TestXxHash64.assertHash(2654435761L, this.buffer, 32, -2545780413506618609L);
        TestXxHash64.assertHash(0L, this.buffer, this.buffer.length(), 1057031117799454893L);
        TestXxHash64.assertHash(2654435761L, this.buffer, this.buffer.length(), -3844287129753543135L);
    }

    private static void assertHash(long seed, Slice data, int length, long expected) throws IOException {
        Assert.assertEquals((long)XxHash64.hash((long)seed, (Slice)data, (int)0, (int)length), (long)expected);
        Assert.assertEquals((long)XxHash64.hash((long)seed, (Slice)data.slice(0, length)), (long)expected);
        Assert.assertEquals((long)new XxHash64(seed).update(data.slice(0, length)).hash(), (long)expected);
        Assert.assertEquals((long)new XxHash64(seed).update(data, 0, length).hash(), (long)expected);
        Assert.assertEquals((long)new XxHash64(seed).update(data.getBytes(0, length)).hash(), (long)expected);
        Assert.assertEquals((long)new XxHash64(seed).update(data.getBytes(), 0, length).hash(), (long)expected);
        Assert.assertEquals((long)XxHash64.hash((long)seed, (InputStream)new ByteArrayInputStream(data.getBytes(0, length))), (long)expected);
        for (int chunkSize = 1; chunkSize <= length; ++chunkSize) {
            XxHash64 hash = new XxHash64(seed);
            for (int i = 0; i < length; i += chunkSize) {
                int updateSize = Math.min(length - i, chunkSize);
                hash.update(data.slice(i, updateSize));
                Assert.assertEquals((long)hash.hash(), (long)XxHash64.hash((long)seed, (Slice)data, (int)0, (int)(i + updateSize)));
            }
            Assert.assertEquals((long)hash.hash(), (long)expected);
        }
    }

    @Test
    public void testMultipleLengths() throws Exception {
        XXHash64 jpountz = XXHashFactory.fastestInstance().hash64();
        for (int i = 0; i < 20000; ++i) {
            byte[] data = new byte[i];
            long expected = jpountz.hash(data, 0, data.length, 0L);
            Slice slice = Slices.wrappedBuffer((byte[])data);
            Assert.assertEquals((long)XxHash64.hash((Slice)slice), (long)expected);
            Assert.assertEquals((long)new XxHash64().update(slice).hash(), (long)expected);
            Assert.assertEquals((long)new XxHash64().update(data).hash(), (long)expected);
            Assert.assertEquals((long)XxHash64.hash((InputStream)new ByteArrayInputStream(data)), (long)expected);
        }
    }

    @Test
    public void testEmpty() throws Exception {
        long expected = -1205034819632174695L;
        Assert.assertEquals((long)XxHash64.hash((Slice)Slices.EMPTY_SLICE), (long)expected);
        Assert.assertEquals((long)XxHash64.hash((Slice)Slices.EMPTY_SLICE, (int)0, (int)0), (long)expected);
        Assert.assertEquals((long)XxHash64.hash((long)0L, (Slice)Slices.EMPTY_SLICE), (long)expected);
        Assert.assertEquals((long)XxHash64.hash((long)0L, (Slice)Slices.EMPTY_SLICE, (int)0, (int)0), (long)expected);
        Assert.assertEquals((long)new XxHash64().update(Slices.EMPTY_SLICE).hash(), (long)expected);
        Assert.assertEquals((long)new XxHash64().update(Slices.EMPTY_SLICE, 0, 0).hash(), (long)expected);
        Assert.assertEquals((long)new XxHash64().update(EMPTY_BYTES).hash(), (long)expected);
        Assert.assertEquals((long)new XxHash64().update(EMPTY_BYTES, 0, 0).hash(), (long)expected);
        Assert.assertEquals((long)new XxHash64().update(EMPTY_BYTES).update(EMPTY_BYTES, 0, 0).update(Slices.EMPTY_SLICE).update(Slices.EMPTY_SLICE, 0, 0).hash(), (long)expected);
    }

    @Test
    public void testHashLong() throws Exception {
        Assert.assertEquals((long)XxHash64.hash((long)this.buffer.getLong(0)), (long)XxHash64.hash((Slice)this.buffer, (int)0, (int)8));
    }
}

