/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.commons.date;

import io.alapierre.common.util.NullUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class DateUtils {
    private DateUtils() {
    }

    public static boolean isSunday(@NotNull LocalDate day) {
        if (day == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.isSunday must not be null");
        }
        return day.getDayOfWeek().getValue() == 7;
    }

    public static boolean isSatday(@NotNull LocalDate day) {
        if (day == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.isSatday must not be null");
        }
        return day.getDayOfWeek().getValue() == 6;
    }

    public static Date atStartOfDay(Date date) {
        LocalDateTime localDateTime = DateUtils.asLocalDateTime(date);
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        return DateUtils.asDate(startOfDay);
    }

    public static Date atEndOfDay(Date date) {
        LocalDateTime localDateTime = DateUtils.asLocalDateTime(date);
        LocalDateTime endOfDay = localDateTime.with(LocalTime.MAX);
        return DateUtils.asDate(endOfDay);
    }

    @Contract(value="null -> null")
    public static Date asDate(LocalDate localDate) {
        return localDate != null ? Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    @Contract(value="null -> null")
    public static Date asDate(LocalDateTime localDateTime) {
        return localDateTime != null ? Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    @Contract(value="null -> null")
    public static LocalDate asLocalDate(Date date) {
        return date != null ? Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate() : null;
    }

    public static LocalDateTime asLocalDateTime(@NotNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.asLocalDateTime must not be null");
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime asLocalDateTime(@NotNull LocalDate date, @NotNull LocalTime time) {
        if (date == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.asLocalDateTime must not be null");
        }
        if (time == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.asLocalDateTime must not be null");
        }
        return LocalDateTime.of(date, time);
    }

    @Contract(value="null -> null")
    public static LocalDate asLocalDate(LocalDateTime date) {
        return (LocalDate)NullUtil.ifNotNull((Object)date, LocalDateTime::toLocalDate);
    }

    @Contract(value="null -> null")
    public static LocalTime asLocalTime(LocalDateTime date) {
        return (LocalTime)NullUtil.ifNotNull((Object)date, LocalDateTime::toLocalTime);
    }

    public static Stream<LocalDate> datesFromTo(@NotNull LocalDate from, @NotNull LocalDate to) {
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.datesFromTo must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.datesFromTo must not be null");
        }
        DateUtils.checkDates(from, to);
        return DateUtils.datesForDays(from, ChronoUnit.DAYS.between(from, to) + 1L);
    }

    private static void checkDates(LocalDate from, LocalDate to) {
        Objects.requireNonNull(from, "data pocz\u0105tkowa nie mo\u017ce by\u0107 null");
        Objects.requireNonNull(to, "data ko\u0144cowa nie mo\u017ce by\u0107 null");
        if (to.isBefore(from)) {
            throw new IllegalArgumentException("Data " + from + " \"od\" nie mo\u017ce by\u0107 wi\u0119ksza od " + to + " \"do\"");
        }
    }

    private static Stream<LocalDate> datesForDays(@NotNull LocalDate from, long days) {
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.datesForDays must not be null");
        }
        return Stream.iterate(from, day -> day.plusDays(1L)).limit(days);
    }

    /*
     * WARNING - void declaration
     */
    static Map<LocalDate, ?> mapDates(@NotNull LocalDate from, long days, @NotNull Function<LocalDate, ?> function) {
        void valueMapper;
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.mapDates must not be null");
        }
        if (function == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/DateUtils.mapDates must not be null");
        }
        return DateUtils.datesForDays(from, days).collect(Collectors.toMap(Function.identity(), valueMapper, (v1, v2) -> {
            throw new IllegalArgumentException();
        }, TreeMap::new));
    }

    public static Map<LocalDate, ?> mapDates(@NotNull LocalDate from, LocalDate to, @NotNull Function<LocalDate, ?> valueMapper) {
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.mapDates must not be null");
        }
        if (valueMapper == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/DateUtils.mapDates must not be null");
        }
        DateUtils.checkDates(from, to);
        return DateUtils.mapDates(from, ChronoUnit.DAYS.between(from, to) + 1L, valueMapper);
    }

    public static long monthsBetweenDates(@NotNull LocalDate from, @NotNull LocalDate to) {
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.monthsBetweenDates must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.monthsBetweenDates must not be null");
        }
        return ChronoUnit.MONTHS.between(from, to);
    }

    public static long weeksBetweenDates(@NotNull LocalDate from, @NotNull LocalDate to) {
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.weeksBetweenDates must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.weeksBetweenDates must not be null");
        }
        return ChronoUnit.WEEKS.between(from, to);
    }

    public static long daysBetweenDates(@NotNull LocalDate from, @NotNull LocalDate to) {
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.daysBetweenDates must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.daysBetweenDates must not be null");
        }
        return ChronoUnit.DAYS.between(from, to);
    }

    static long hoursBetweenDates(@NotNull LocalDateTime from, @NotNull LocalDateTime to) {
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.hoursBetweenDates must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.hoursBetweenDates must not be null");
        }
        return ChronoUnit.HOURS.between(from, to);
    }

    public static boolean isRangeInRange(@NotNull LocalDateTime dayFrom, @NotNull LocalDateTime dayTo, @NotNull LocalDateTime from, @NotNull LocalDateTime to) {
        if (dayFrom == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.isRangeInRange must not be null");
        }
        if (dayTo == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.isRangeInRange must not be null");
        }
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/DateUtils.isRangeInRange must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/commons/date/DateUtils.isRangeInRange must not be null");
        }
        return !dayFrom.isBefore(from) && !dayFrom.isAfter(to) && !dayTo.isBefore(from) && !dayTo.isAfter(to);
    }

    public static boolean isDayInRange(@NotNull Date day, @NotNull Date from, @NotNull Date to) {
        if (day == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.isDayInRange must not be null");
        }
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.isDayInRange must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/DateUtils.isDayInRange must not be null");
        }
        return !day.before(from) && !day.after(to);
    }

    public static boolean isDayInRange(@NotNull LocalDate day, @NotNull LocalDate from, @NotNull LocalDate to) {
        if (day == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.isDayInRange must not be null");
        }
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.isDayInRange must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/DateUtils.isDayInRange must not be null");
        }
        return !day.isBefore(from) && !day.isAfter(to);
    }

    public static boolean isDayInRange(@NotNull LocalDate day, @NotNull Date from, @NotNull Date to) {
        if (day == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.isDayInRange must not be null");
        }
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.isDayInRange must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/DateUtils.isDayInRange must not be null");
        }
        return !day.isBefore(DateUtils.asLocalDate(from)) && !day.isAfter(DateUtils.asLocalDate(to));
    }

    public static boolean isDayInRange(@NotNull LocalDateTime day, @NotNull LocalDateTime from, @NotNull LocalDateTime to) {
        if (day == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.isDayInRange must not be null");
        }
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.isDayInRange must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/DateUtils.isDayInRange must not be null");
        }
        return !day.isBefore(from) && !day.isAfter(to);
    }

    public static boolean isAfterOrEquals(@NotNull LocalDate day1, @NotNull LocalDate day2) {
        if (day1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.isAfterOrEquals must not be null");
        }
        if (day2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.isAfterOrEquals must not be null");
        }
        return !day1.isBefore(day2);
    }

    public static boolean isBeforeOrEquals(@NotNull LocalDate day1, @NotNull LocalDate day2) {
        if (day1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.isBeforeOrEquals must not be null");
        }
        if (day2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.isBeforeOrEquals must not be null");
        }
        return !day1.isAfter(day2);
    }

    public static boolean overlap(@NotNull LocalDate start1, @NotNull LocalDate end1, @NotNull LocalDate start2, @NotNull LocalDate end2) {
        if (start1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.overlap must not be null");
        }
        if (end1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.overlap must not be null");
        }
        if (start2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/DateUtils.overlap must not be null");
        }
        if (end2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/commons/date/DateUtils.overlap must not be null");
        }
        return !start1.isAfter(end2) && !end1.isBefore(start2);
    }

    public static boolean overlap(@NotNull LocalDateTime start1, @NotNull LocalDateTime end1, @NotNull LocalDateTime start2, @NotNull LocalDateTime end2) {
        if (start1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.overlap must not be null");
        }
        if (end1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.overlap must not be null");
        }
        if (start2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/DateUtils.overlap must not be null");
        }
        if (end2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/commons/date/DateUtils.overlap must not be null");
        }
        return !start1.isAfter(end2) && !end1.isBefore(start2);
    }

    public static boolean overlapWithoutBorder(@NotNull LocalDateTime start1, @NotNull LocalDateTime end1, @NotNull LocalDateTime start2, @NotNull LocalDateTime end2) {
        if (start1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.overlapWithoutBorder must not be null");
        }
        if (end1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/DateUtils.overlapWithoutBorder must not be null");
        }
        if (start2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/DateUtils.overlapWithoutBorder must not be null");
        }
        if (end2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/commons/date/DateUtils.overlapWithoutBorder must not be null");
        }
        return !start1.isAfter(end2) && !end1.isBefore(start2) && !start1.equals(end2) && !end1.equals(start2);
    }

    public static LocalDate parseDate(String dateFormatted) {
        return LocalDate.parse(dateFormatted, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public static LocalDate lastDayOfMonth(@NotNull LocalDate initial) {
        if (initial == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.lastDayOfMonth must not be null");
        }
        return initial.withDayOfMonth(initial.lengthOfMonth());
    }

    public static LocalDate firstDayOfMonth(@NotNull LocalDate initial) {
        if (initial == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.firstDayOfMonth must not be null");
        }
        return initial.withDayOfMonth(1);
    }

    public static LocalDate firstDayOfYear(@NotNull LocalDate initial) {
        if (initial == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.firstDayOfYear must not be null");
        }
        return initial.withDayOfMonth(1).withMonth(Month.JANUARY.getValue());
    }

    public static LocalDate lastDayOfYear(@NotNull LocalDate initial) {
        if (initial == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.lastDayOfYear must not be null");
        }
        return initial.withMonth(Month.DECEMBER.getValue()).withDayOfMonth(31);
    }

    public static LocalDate monthlyPeriodEndFrom(@NotNull LocalDate initial, long months) {
        if (initial == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.monthlyPeriodEndFrom must not be null");
        }
        return initial.getDayOfMonth() == 1 ? DateUtils.firstDayOfMonth(initial.plusMonths(months)).minusDays(1L) : initial.plusMonths(months);
    }

    public static int weekNumber(@NotNull LocalDate initial) {
        if (initial == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/DateUtils.weekNumber must not be null");
        }
        WeekFields weekFields = WeekFields.of(Locale.getDefault());
        return initial.get(weekFields.weekOfWeekBasedYear());
    }
}

