/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.io;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtils {
    private static final Logger log = LoggerFactory.getLogger(SystemUtils.class);
    public static String OS_NAME = SystemUtils.getSystemProperty("os.name").orElse("unknown");

    public static boolean isWindows() {
        if (OS_NAME.equals("unknown")) {
            return false;
        }
        return OS_NAME.startsWith("Windows");
    }

    public static Optional<String> getSystemProperty(String property) {
        try {
            return Optional.ofNullable(System.getProperty(property));
        }
        catch (SecurityException ex) {
            log.error("Caught a SecurityException reading the system property '" + property + "'; the SystemUtils property value will default to null.");
            return Optional.empty();
        }
    }
}

