/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.common.util;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import org.jetbrains.annotations.NotNull;

public final class ReflectionUtil {
    public static <T> T getValue(@NotNull Class<T> type, String value) {
        if (type == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/common/util/ReflectionUtil.getValue must not be null");
        }
        Object response = null;
        if (type.isEnum()) {
            response = ReflectionUtil.fromEnum(type, value);
        } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            response = ReflectionUtil.fromBoolean(value);
        } else if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            response = ReflectionUtil.fromLong(value);
        } else if (type.equals(String.class)) {
            response = value;
        } else if (type.equals(BigDecimal.class)) {
            response = ReflectionUtil.fromBigDecimal(value);
        } else if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            response = ReflectionUtil.fromDouble(value);
        } else if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            response = ReflectionUtil.fromInteger(value);
        }
        return (T)response;
    }

    private static Object fromEnum(@NotNull Class<? extends Enum> type, String value) {
        if (type == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/common/util/ReflectionUtil.fromEnum must not be null");
        }
        return Enum.valueOf(type, value);
    }

    private static Boolean fromBoolean(String value) {
        return Boolean.valueOf(value);
    }

    private static Long fromLong(String value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        return Long.valueOf(value);
    }

    private static BigDecimal fromBigDecimal(String value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        return BigDecimal.valueOf(Double.parseDouble(value));
    }

    private static Double fromDouble(String value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        return Double.valueOf(value);
    }

    private static Integer fromInteger(String value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public static void preventNullInBoolean(@NotNull Object target, boolean value) throws IllegalAccessException, NoSuchFieldException {
        if (target == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/common/util/ReflectionUtil.preventNullInBoolean must not be null");
        }
        for (Field field : target.getClass().getDeclaredFields()) {
            Object fieldValue;
            field.setAccessible(true);
            if (!field.getType().equals(Boolean.class) || (fieldValue = field.get(target)) != null) continue;
            Field oldField = target.getClass().getDeclaredField(field.getName());
            oldField.setAccessible(true);
            oldField.set(target, value);
        }
    }
}

