/*
 * Decompiled with CFR 0.152.
 */
package pl.com.softproject.utils.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTTransformator {
    private Transformer transformer;

    public XSLTTransformator(File xsltFile) throws FileNotFoundException, TransformerConfigurationException {
        FileInputStream xsltImputStream = new FileInputStream(xsltFile);
        StreamSource xsltSource = new StreamSource(xsltImputStream);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        this.transformer = transFactory.newTransformer(xsltSource);
    }

    public XSLTTransformator(InputStream is) throws FileNotFoundException, TransformerConfigurationException {
        StreamSource xsltSource = new StreamSource(is);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        this.transformer = transFactory.newTransformer(xsltSource);
    }

    public void setEncoding(String encoding) {
        this.transformer.setOutputProperty("encoding", encoding);
    }

    public String getEncoding() {
        return this.transformer.getOutputProperty("encoding");
    }

    public void transform(Reader in, OutputStream out) throws TransformerException {
        StreamResult streamResult = new StreamResult(out);
        this.transformer.transform(new StreamSource(in), streamResult);
    }

    public void transform(Reader in, Writer out) throws TransformerException {
        StreamResult streamResult = new StreamResult(out);
        this.transformer.transform(new StreamSource(in), streamResult);
    }

    public void transform(Source in, OutputStream out) throws TransformerException {
        StreamResult streamResult = new StreamResult(out);
        this.transformer.transform(in, streamResult);
    }

    public void transform(Source in, Result out) throws TransformerException {
        this.transformer.transform(in, out);
    }

    public String transform(String source) throws TransformerException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.transform((Reader)new StringReader(source), (OutputStream)result);
        return ((Object)result).toString();
    }

    public void transform(String source, OutputStream out) throws TransformerException {
        this.transform((Reader)new StringReader(source), out);
    }
}

