/*
 * Decompiled with CFR 0.152.
 */
package pl.com.softproject.utils.xml.stax;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.com.softproject.utils.xml.stax.XmlElement;

public class ElementFinder {
    private static final Logger log = LoggerFactory.getLogger(ElementFinder.class);
    private final XMLInputFactory factory = XMLInputFactory.newFactory();
    private final LinkedList<String> path = new LinkedList();

    public Optional<XmlElement> find(@NonNull String xml, @NonNull String pathToFind) throws XMLStreamException {
        if (xml == null) {
            throw new NullPointerException("xml is marked non-null but is null");
        }
        if (pathToFind == null) {
            throw new NullPointerException("pathToFind is marked non-null but is null");
        }
        return this.find((Reader)new StringReader(xml), pathToFind);
    }

    public Optional<XmlElement> find(@NonNull File xml, @NonNull String pathToFind) throws XMLStreamException, IOException {
        if (xml == null) {
            throw new NullPointerException("xml is marked non-null but is null");
        }
        if (pathToFind == null) {
            throw new NullPointerException("pathToFind is marked non-null but is null");
        }
        try (FileReader reader = new FileReader(xml);){
            Optional<XmlElement> optional = this.find((Reader)reader, pathToFind);
            return optional;
        }
    }

    public Set<XmlElement> find(@NonNull File xml, @NonNull Set<String> pathsToFind) throws XMLStreamException, IOException {
        if (xml == null) {
            throw new NullPointerException("xml is marked non-null but is null");
        }
        if (pathsToFind == null) {
            throw new NullPointerException("pathsToFind is marked non-null but is null");
        }
        try (FileReader reader = new FileReader(xml);){
            Set<XmlElement> set = this.find((Reader)reader, pathsToFind);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<XmlElement> find(@NonNull Reader xml, @NonNull Set<String> pathsToFind) throws XMLStreamException {
        if (xml == null) {
            throw new NullPointerException("xml is marked non-null but is null");
        }
        if (pathsToFind == null) {
            throw new NullPointerException("pathsToFind is marked non-null but is null");
        }
        this.path.clear();
        XMLEventReader eventReader = null;
        HashSet<XmlElement> res = new HashSet<XmlElement>();
        try {
            eventReader = this.factory.createXMLEventReader(xml);
            while (eventReader.hasNext()) {
                XMLEvent xmlEvent = eventReader.nextEvent();
                if (xmlEvent.isStartElement()) {
                    StartElement startElement = xmlEvent.asStartElement();
                    this.path.addLast(startElement.getName().getLocalPart());
                    String pathAsString = String.join((CharSequence)"/", this.path);
                    if (!pathsToFind.contains(pathAsString)) continue;
                    res.add(this.createXmlElement(xmlEvent, pathAsString, eventReader));
                    continue;
                }
                if (!xmlEvent.isEndElement()) continue;
                this.path.removeLast();
            }
        }
        finally {
            if (eventReader != null) {
                try {
                    eventReader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        HashSet<XmlElement> hashSet = res;
        if (hashSet == null) {
            throw new IllegalStateException("NotNull method pl/com/softproject/utils/xml/stax/ElementFinder.find must not return null");
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<XmlElement> find(@NonNull Reader xml, @NonNull String pathToFind) throws XMLStreamException {
        if (xml == null) {
            throw new NullPointerException("xml is marked non-null but is null");
        }
        if (pathToFind == null) {
            throw new NullPointerException("pathToFind is marked non-null but is null");
        }
        this.path.clear();
        XMLEventReader eventReader = null;
        try {
            eventReader = this.factory.createXMLEventReader(xml);
            while (eventReader.hasNext()) {
                XMLEvent xmlEvent = eventReader.nextEvent();
                if (xmlEvent.isStartElement()) {
                    StartElement startElement = xmlEvent.asStartElement();
                    this.path.addLast(startElement.getName().getLocalPart());
                    String pathAsString = String.join((CharSequence)"/", this.path);
                    if (!pathAsString.equals(pathToFind)) continue;
                    Optional<XmlElement> optional = Optional.of(this.createXmlElement(xmlEvent, pathAsString, eventReader));
                    return optional;
                }
                if (!xmlEvent.isEndElement()) continue;
                this.path.removeLast();
            }
        }
        finally {
            if (eventReader != null) {
                try {
                    eventReader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        return Optional.empty();
    }

    protected XmlElement createXmlElement(@NonNull XMLEvent event, @NonNull String path, @NonNull XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent next;
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (eventReader == null) {
            throw new NullPointerException("eventReader is marked non-null but is null");
        }
        StartElement startElement = event.asStartElement();
        QName name = startElement.getName();
        Iterable iterable = startElement::getAttributes;
        Set<Attribute> attributes = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toSet());
        String value = null;
        if (eventReader.hasNext() && (next = eventReader.nextEvent()).isCharacters()) {
            value = next.asCharacters().getData();
        }
        return new XmlElement(path, name, value, attributes);
    }
}

