/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.batch;

import io.alapierre.ksef.batch.BatchProcessingException;
import io.alapierre.ksef.batch.InvoiceSource;
import io.alapierre.ksef.batch.model.BatchConfig;
import io.alapierre.ksef.batch.model.BatchPartInfo;
import io.alapierre.ksef.batch.model.BatchResult;
import io.alapierre.ksef.batch.model.InvoiceHash;
import io.alapierre.ksef.batch.model.InvoiceItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.akmf.ksef.sdk.api.builders.batch.OpenBatchSessionRequestBuilder;
import pl.akmf.ksef.sdk.client.interfaces.CryptographyService;
import pl.akmf.ksef.sdk.client.interfaces.KSeFClient;
import pl.akmf.ksef.sdk.client.model.ApiException;
import pl.akmf.ksef.sdk.client.model.session.EncryptionData;
import pl.akmf.ksef.sdk.client.model.session.FileMetadata;
import pl.akmf.ksef.sdk.client.model.session.SchemaVersion;
import pl.akmf.ksef.sdk.client.model.session.SessionValue;
import pl.akmf.ksef.sdk.client.model.session.SystemCode;
import pl.akmf.ksef.sdk.client.model.session.batch.BatchPartSendingInfo;
import pl.akmf.ksef.sdk.client.model.session.batch.OpenBatchSessionRequest;
import pl.akmf.ksef.sdk.client.model.session.batch.OpenBatchSessionResponse;
import pl.akmf.ksef.sdk.client.model.session.batch.PackagePartSignatureInitResponseType;

public class BatchHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchHelper.class);
    private final CryptographyService cryptographyService;
    private final KSeFClient client;

    public BatchResult prepareBatch(InvoiceSource source, BatchConfig config) {
        String zipHash;
        String encryptedCipherKey;
        byte[] iv;
        ZipContext zipContext = this.createZipWithHashes(source);
        File plainZipFile = zipContext.file();
        log.info("Utworzono plik ZIP: {}, rozmiar: {}", (Object)plainZipFile.getAbsolutePath(), (Object)plainZipFile.length());
        ArrayList<BatchPartInfo> encryptedParts = new ArrayList<BatchPartInfo>();
        long zipSize = 0L;
        try {
            EncryptionData encryptionData = this.cryptographyService.getEncryptionData();
            byte[] aesKey = encryptionData.cipherKey();
            iv = encryptionData.cipherIv();
            encryptedCipherKey = encryptionData.encryptedCipherKey();
            try (FileInputStream is = new FileInputStream(plainZipFile);){
                FileMetadata meta = this.cryptographyService.getMetaData(is);
                zipHash = meta.getHashSHA();
                zipSize = meta.getFileSize();
            }
            log.info("ZIP Meta: size={}, hash={}", (Object)zipSize, (Object)zipHash);
            try (FileInputStream fis = new FileInputStream(plainZipFile);){
                int bytesRead;
                byte[] buffer = new byte[config.maxPartSize()];
                int partIndex = 1;
                while ((bytesRead = ((InputStream)fis).read(buffer)) > 0) {
                    byte[] partData = bytesRead < buffer.length ? Arrays.copyOf(buffer, bytesRead) : buffer;
                    byte[] encryptedData = this.cryptographyService.encryptBytesWithAES256(partData, aesKey, iv);
                    FileMetadata partMeta = this.cryptographyService.getMetaData(encryptedData);
                    String cipherHash = partMeta.getHashSHA();
                    long cipherSize = partMeta.getFileSize();
                    Path partOutputPath = config.outputDir().resolve(String.format("part-%d.enc", partIndex));
                    Files.write(partOutputPath, encryptedData, new OpenOption[0]);
                    encryptedParts.add(new BatchPartInfo(partIndex, partOutputPath, cipherSize, cipherHash));
                    log.debug("Przetworzono cz\u0119\u015b\u0107 {}, plainSize: {}, cipherSize: {}", new Object[]{partIndex, partData.length, cipherSize});
                    ++partIndex;
                }
            }
        }
        catch (Exception e) {
            log.warn("Problem z tworzeniem i szyfrowaniem paczek dla wysy\u0142ki wsadowej, czyszczenie pozosta\u0142o\u015bci, usuwam {} plik\u00f3w paczek", (Object)encryptedParts.size());
            for (BatchPartInfo part : encryptedParts) {
                try {
                    Files.deleteIfExists(part.cipherPath());
                }
                catch (IOException ignored) {
                    log.warn("Nie uda\u0142o si\u0119 posprz\u0105ta\u0107 pliku po b\u0142\u0119dzie: {}", (Object)part.cipherPath());
                }
            }
            throw new BatchProcessingException("B\u0142\u0105d podczas przygotowywania wysy\u0142ki batch", e);
        }
        finally {
            boolean deleted;
            if (config.cleanup() && plainZipFile.exists() && !(deleted = plainZipFile.delete())) {
                log.warn("Nie uda\u0142o si\u0119 usun\u0105\u0107 tymczasowego pliku ZIP: {}", (Object)plainZipFile);
            }
        }
        Path zipPath = config.cleanup() || !plainZipFile.exists() ? null : plainZipFile.toPath();
        return new BatchResult(zipPath, zipSize, zipHash, encryptedParts, zipContext.hashes(), iv, encryptedCipherKey);
    }

    public OpenBatchSessionResponse sendBatch(BatchResult result, String authToken) throws ApiException {
        OpenBatchSessionRequest batchRequest = this.prepareRequest(result);
        OpenBatchSessionResponse session = this.client.openBatchSession(batchRequest, authToken);
        List<PackagePartSignatureInitResponseType> uploadInstructions = session.getPartUploadRequests();
        ArrayList<String> errors = new ArrayList<String>();
        for (BatchPartInfo partInfo : result.parts()) {
            PackagePartSignatureInitResponseType instruction = uploadInstructions.stream().filter(i -> i.getOrdinalNumber() == partInfo.index()).findFirst().orElseThrow(() -> new IllegalStateException("Brak instrukcji wysy\u0142ki z KSeF dla cz\u0119\u015bci nr " + partInfo.index()));
            try {
                byte[] partData = Files.readAllBytes(partInfo.cipherPath());
                BatchPartSendingInfo info = new BatchPartSendingInfo();
                info.setOrdinalNumber(partInfo.index());
                info.setData(partData);
                FileMetadata meta = new FileMetadata();
                meta.setFileSize(partInfo.cipherSize());
                meta.setHashSHA(partInfo.cipherHash());
                info.setMetadata(meta);
                this.client.singleBatchPartSendingProcess(info, instruction, errors);
                if (errors.isEmpty()) continue;
                String errorMsg = String.join((CharSequence)"\n", errors);
                throw new ApiException("B\u0142\u0105d wysy\u0142ki cz\u0119\u015bci " + partInfo.index() + ": " + errorMsg);
            }
            catch (IOException e) {
                throw new BatchProcessingException("B\u0142\u0105d IO podczas odczytu cz\u0119\u015bci paczki: " + String.valueOf(partInfo.cipherPath()), e);
            }
        }
        return session;
    }

    private OpenBatchSessionRequest prepareRequest(BatchResult batchResult) {
        OpenBatchSessionRequestBuilder builder = OpenBatchSessionRequestBuilder.create().withFormCode(SystemCode.FA_2, SchemaVersion.VERSION_1_0E, SessionValue.FA).withOfflineMode(false).withBatchFile(batchResult.zipSize(), batchResult.zipHash()).withEncryption(batchResult.encryptedCipherKey(), batchResult.encodedIv());
        for (BatchPartInfo part : batchResult.parts()) {
            builder.addBatchFilePart(part.index(), part.cipherSize(), part.cipherHash());
        }
        return builder.endBatchFile().build();
    }

    public void removeEncryptedParts(BatchResult result) {
        for (BatchPartInfo part : result.parts()) {
            try {
                Files.deleteIfExists(part.cipherPath());
                log.debug("Usuni\u0119to plik cz\u0119\u015bci: {}", (Object)part.cipherPath());
            }
            catch (IOException e) {
                log.warn("Nie uda\u0142o si\u0119 usun\u0105\u0107 pliku cz\u0119\u015bci: {}", (Object)part.cipherPath(), (Object)e);
            }
        }
    }

    protected ZipContext createZipWithHashes(InvoiceSource source) {
        File zip;
        ArrayList<InvoiceHash> invoiceHashes = new ArrayList<InvoiceHash>();
        try {
            zip = File.createTempFile("invoices", ".zip");
            try (FileOutputStream zipStream = new FileOutputStream(zip);
                 ZipOutputStream archive = new ZipOutputStream(zipStream);){
                for (InvoiceItem item : source) {
                    archive.putNextEntry(new ZipEntry(item.fileName()));
                    archive.write(item.content());
                    archive.closeEntry();
                    invoiceHashes.add(new InvoiceHash(item.fileName(), item.hash()));
                }
                archive.finish();
            }
        }
        catch (IOException e) {
            throw new BatchProcessingException("Nie mo\u017cna utworzy\u0107 tymczasowego pliku ZIP", e);
        }
        return new ZipContext(zip, invoiceHashes);
    }

    @Generated
    public BatchHelper(CryptographyService cryptographyService, KSeFClient client) {
        this.cryptographyService = cryptographyService;
        this.client = client;
    }

    protected record ZipContext(File file, List<InvoiceHash> hashes) {
    }
}

