/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.client.iterator;

import io.alapierre.ksef.client.ApiException;
import io.alapierre.ksef.client.iterator.PageSupplier;
import io.alapierre.ksef.client.iterator.PageableResult;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class KsefResultStream<T> {
    private int currentIndex = 0;
    private int totalIndex = 0;
    private PageableResult<T> currentPage;
    private int currentPageNumber = 0;
    private int currentPageSize;
    private int totalNumberOfElements;
    private PageSupplier<PageableResult<T>> supplier;

    public static <T> Stream<T> builder(PageSupplier<PageableResult<T>> supplier) throws ApiException {
        KsefResultStream<T> in = new KsefResultStream<T>();
        return in.stream(supplier);
    }

    public Stream<T> stream(PageSupplier<PageableResult<T>> supplier) throws ApiException {
        this.supplier = supplier;
        this.nextPage(this.currentPageNumber);
        if (this.currentPage.getNumberOfElements() == 0) {
            return Stream.empty();
        }
        return Stream.iterate(this.next().apply(null), this.hasNext(), this.next());
    }

    private Predicate<T> hasNext() {
        return t -> this.totalIndex <= this.totalNumberOfElements;
    }

    private UnaryOperator<T> next() {
        return t -> {
            if (this.totalIndex == this.totalNumberOfElements) {
                ++this.totalIndex;
                return null;
            }
            if (this.currentIndex >= this.currentPageSize) {
                try {
                    this.nextPage(++this.currentPageNumber);
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            }
            ++this.totalIndex;
            return this.currentPage.getItems().get(this.currentIndex++);
        };
    }

    private void nextPage(int pageNumber) throws ApiException {
        this.currentPage = this.supplier.get(pageNumber);
        this.currentPageSize = this.currentPage.getItems().size();
        this.totalNumberOfElements = this.currentPage.getNumberOfElements();
        this.currentIndex = 0;
    }
}

