/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.xml.model;

import io.alapierre.ksef.xml.model.AuthRequestSerializer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import pl.gov.mf.ksef.schema.gtw.svc.online.auth.request._2021._10._01._0001.InitSessionSignedRequest;
import pl.gov.mf.ksef.schema.gtw.svc.online.auth.request._2021._10._01._0001.InitSessionTokenRequest;
import pl.gov.mf.ksef.schema.gtw.svc.online.types._2021._10._01._0001.AuthorisationContextSignedType;
import pl.gov.mf.ksef.schema.gtw.svc.online.types._2021._10._01._0001.AuthorisationContextTokenType;
import pl.gov.mf.ksef.schema.gtw.svc.online.types._2021._10._01._0001.ObjectFactory;
import pl.gov.mf.ksef.schema.gtw.svc.types._2021._10._01._0001.AuthorisationTypeType;
import pl.gov.mf.ksef.schema.gtw.svc.types._2021._10._01._0001.DocumentTypeType;
import pl.gov.mf.ksef.schema.gtw.svc.types._2021._10._01._0001.FormCodeType;
import pl.gov.mf.ksef.schema.gtw.svc.types._2021._10._01._0001.ServiceType;
import pl.gov.mf.ksef.schema.gtw.svc.types._2021._10._01._0001.SubjectIdentifierByCompanyType;

public class AuthRequestUtil {
    private AuthRequestUtil() {
    }

    @NotNull
    public static InitSessionTokenRequest prepareTokenAuthRequest(@NotNull String challenge, @NotNull String identifier, @NotNull String encryptedToken) {
        if (challenge == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/xml/model/AuthRequestUtil.prepareTokenAuthRequest must not be null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/xml/model/AuthRequestUtil.prepareTokenAuthRequest must not be null");
        }
        if (encryptedToken == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/xml/model/AuthRequestUtil.prepareTokenAuthRequest must not be null");
        }
        InitSessionTokenRequest initSessionTokenRequest = new InitSessionTokenRequest();
        SubjectIdentifierByCompanyType subjectIdentifier = new SubjectIdentifierByCompanyType();
        subjectIdentifier.setIdentifier(identifier);
        AuthorisationContextTokenType context = new AuthorisationContextTokenType();
        context.setChallenge(challenge);
        context.setIdentifier(subjectIdentifier);
        context.setToken(encryptedToken);
        context.setDocumentType(AuthRequestUtil.prepareDocumentType());
        initSessionTokenRequest.setContext(context);
        InitSessionTokenRequest initSessionTokenRequest2 = initSessionTokenRequest;
        if (initSessionTokenRequest2 == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/xml/model/AuthRequestUtil.prepareTokenAuthRequest must not return null");
        }
        return initSessionTokenRequest2;
    }

    @NotNull
    public static InitSessionSignedRequest prepareAuthRequest(@NotNull String challenge, @NotNull String identifier) {
        if (challenge == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/xml/model/AuthRequestUtil.prepareAuthRequest must not be null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/xml/model/AuthRequestUtil.prepareAuthRequest must not be null");
        }
        pl.gov.mf.ksef.schema.gtw.svc.online.auth.request._2021._10._01._0001.ObjectFactory factory = new pl.gov.mf.ksef.schema.gtw.svc.online.auth.request._2021._10._01._0001.ObjectFactory();
        ObjectFactory contextFactory = new ObjectFactory();
        InitSessionSignedRequest request = factory.createInitSessionSignedRequest();
        AuthorisationContextSignedType context = contextFactory.createAuthorisationContextSignedType();
        context.setType(AuthorisationTypeType.SERIAL_NUMBER);
        context.setChallenge(challenge);
        DocumentTypeType documentTypeType = AuthRequestUtil.prepareDocumentType();
        context.setDocumentType(documentTypeType);
        SubjectIdentifierByCompanyType id = new SubjectIdentifierByCompanyType();
        id.setIdentifier(identifier);
        context.setIdentifier(id);
        request.setContext(context);
        InitSessionSignedRequest initSessionSignedRequest = request;
        if (initSessionSignedRequest == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/xml/model/AuthRequestUtil.prepareAuthRequest must not return null");
        }
        return initSessionSignedRequest;
    }

    @NotNull
    public static DocumentTypeType prepareDocumentType() {
        DocumentTypeType documentTypeType = new DocumentTypeType();
        documentTypeType.setService(ServiceType.K_SE_F);
        FormCodeType form = new FormCodeType();
        form.setSystemCode("FA (2)");
        form.setSchemaVersion("1-0E");
        form.setTargetNamespace("http://crd.gov.pl/wzor/2023/06/29/12648/");
        form.setValue("FA");
        documentTypeType.setFormCode(form);
        DocumentTypeType documentTypeType2 = documentTypeType;
        if (documentTypeType2 == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/xml/model/AuthRequestUtil.prepareDocumentType must not return null");
        }
        return documentTypeType2;
    }

    public static void requestToFile(@NotNull InitSessionSignedRequest request, @NotNull File outputFile) {
        if (request == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/xml/model/AuthRequestUtil.requestToFile must not be null");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/xml/model/AuthRequestUtil.requestToFile must not be null");
        }
        AuthRequestSerializer serializer = new AuthRequestSerializer();
        serializer.toFile(request, outputFile.getAbsolutePath());
    }

    public static byte[] requestToBytes(@NotNull InitSessionSignedRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/xml/model/AuthRequestUtil.requestToBytes must not be null");
        }
        AuthRequestSerializer serializer = new AuthRequestSerializer();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        serializer.toStream(request, os);
        return os.toByteArray();
    }
}

