/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.common.auth.AuthToken;
import io.apiman.common.auth.ISharedSecretSource;
import java.util.Date;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthTokenUtil {
    private static Logger logger = LoggerFactory.getLogger(AuthTokenUtil.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static ISharedSecretSource sharedSecretSource;

    private AuthTokenUtil() {
    }

    public static final String produceToken(String principal, Set<String> roles, int expiresInMillis) {
        AuthToken authToken = AuthTokenUtil.createAuthToken(principal, roles, expiresInMillis);
        String json = AuthTokenUtil.toJSON(authToken);
        return StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])StringUtils.getBytesUtf8((String)json)));
    }

    public static final AuthToken consumeToken(String encodedJson) throws IllegalArgumentException {
        String json = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)encodedJson));
        AuthToken token = AuthTokenUtil.fromJSON(json);
        AuthTokenUtil.validateToken(token);
        return token;
    }

    public static final void validateToken(AuthToken token) throws IllegalArgumentException {
        if (token.getExpiresOn().before(new Date())) {
            throw new IllegalArgumentException("Authentication token expired: " + token.getExpiresOn());
        }
        String validSig = AuthTokenUtil.generateSignature(token);
        if (token.getSignature() == null || !token.getSignature().equals(validSig)) {
            throw new IllegalArgumentException("Missing or invalid signature on the auth token.");
        }
    }

    public static final AuthToken createAuthToken(String principal, Set<String> roles, int expiresInMillis) {
        AuthToken token = new AuthToken();
        token.setIssuedOn(new Date());
        token.setExpiresOn(new Date(System.currentTimeMillis() + (long)expiresInMillis));
        token.setPrincipal(principal);
        token.setRoles(roles);
        AuthTokenUtil.signAuthToken(token);
        return token;
    }

    public static final void signAuthToken(AuthToken token) {
        String signature = AuthTokenUtil.generateSignature(token);
        token.setSignature(signature);
    }

    private static String generateSignature(AuthToken token) {
        StringBuilder builder = new StringBuilder();
        builder.append(token.getPrincipal());
        builder.append("||");
        builder.append(token.getExpiresOn().getTime());
        builder.append("||");
        builder.append(token.getIssuedOn().getTime());
        builder.append("||");
        TreeSet<String> roles = new TreeSet<String>(token.getRoles());
        boolean first = true;
        for (String role : roles) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(role);
        }
        builder.append("||");
        builder.append(sharedSecretSource.getSharedSecret());
        return DigestUtils.sha256Hex((String)builder.toString());
    }

    public static final String toJSON(AuthToken token) {
        try {
            return mapper.writer().writeValueAsString((Object)token);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final AuthToken fromJSON(String json) {
        try {
            return (AuthToken)mapper.reader(AuthToken.class).readValue(json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ServiceLoader<ISharedSecretSource> loader = ServiceLoader.load(ISharedSecretSource.class);
        Iterator<ISharedSecretSource> iterator = loader.iterator();
        if (iterator.hasNext()) {
            ISharedSecretSource source;
            sharedSecretSource = source = iterator.next();
        }
        if (sharedSecretSource == null) {
            logger.warn("Missing a Shared-Secret source for auth-token style authentication.  Defaulting to insecure, hard-coded value.");
            sharedSecretSource = new ISharedSecretSource(){

                @Override
                public String getSharedSecret() {
                    return "2BB6E867BC7564162AB1FD26BE61E49365934FBA9B3E56B1323ABE104C798D5C";
                }
            };
        }
    }
}

