/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.util;

import org.apache.commons.lang3.StringUtils;

public class ApimanPathUtils {
    public static final String X_API_VERSION_HEADER = "X-API-Version";
    public static final String ACCEPT_HEADER = "Accept";

    private ApimanPathUtils() {
    }

    public static final ApiRequestPathInfo parseApiRequestPath(String apiVersionHeader, String acceptHeader, String pathInfo) {
        String[] split;
        int minParts;
        ApiRequestPathInfo info = new ApiRequestPathInfo();
        boolean versionFound = false;
        if (apiVersionHeader != null && apiVersionHeader.trim().length() > 0) {
            info.apiVersion = apiVersionHeader;
            versionFound = true;
        } else if (acceptHeader != null && acceptHeader.startsWith("application/apiman.")) {
            String[] split2 = acceptHeader.split("\\+");
            info.apiVersion = split2[0].substring("application/apiman.".length());
            versionFound = true;
        }
        int n = minParts = versionFound ? 3 : 4;
        if (pathInfo != null && (split = pathInfo.split("/")).length >= minParts) {
            info.orgId = split[1];
            info.apiId = split[2];
            if (!versionFound) {
                info.apiVersion = split[3];
            }
            if (split.length > minParts) {
                StringBuilder resource = new StringBuilder();
                for (int idx = minParts; idx < split.length; ++idx) {
                    resource.append('/');
                    resource.append(ApimanPathUtils.urlEncode(split[idx]));
                }
                if (pathInfo.endsWith("/")) {
                    resource.append('/');
                }
                info.resource = resource.toString();
            } else if (pathInfo.endsWith("/")) {
                info.resource = "/";
            }
        }
        return info;
    }

    public static String urlEncode(String string) {
        return string.replace("#", "%23");
    }

    public static String join(String endpoint, String path) {
        if (endpoint == null || endpoint.isEmpty()) {
            return path;
        }
        if (path == null || path.isEmpty()) {
            return endpoint;
        }
        if (StringUtils.endsWith((CharSequence)endpoint, (CharSequence)"/") && path.startsWith("/")) {
            return endpoint + path.substring(1);
        }
        if (StringUtils.endsWith((CharSequence)endpoint, (CharSequence)"/") ^ path.startsWith("/")) {
            return endpoint + path;
        }
        return endpoint + "/" + path;
    }

    public static class ApiRequestPathInfo {
        public String orgId;
        public String apiId;
        public String apiVersion;
        public String resource;
    }
}

