/*
 * Decompiled with CFR 0.152.
 */
package io.appwrite.cookies;

import java.io.IOException;
import java.net.CookieHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016JV\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00152F\u0010\u0019\u001aB\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\bj\u0002`\u0010J\u001e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010\u0005\u001aN\u0012\u0004\u0012\u00020\u0007\u0012D\u0012B\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\bj\u0002`\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/appwrite/cookies/ListenableCookieJar;", "Lokhttp3/CookieJar;", "cookieHandler", "Ljava/net/CookieHandler;", "(Ljava/net/CookieHandler;)V", "listeners", "", "", "Lkotlin/Function2;", "", "Lokhttp3/Cookie;", "Lkotlin/ParameterName;", "name", "existing", "new", "", "Lio/appwrite/cookies/CookieListener;", "decodeHeaderAsJavaNetCookies", "url", "Lokhttp3/HttpUrl;", "header", "", "loadForRequest", "onSave", "key", "listener", "saveFromResponse", "cookies", "library_release"})
@SourceDebugExtension(value={"SMAP\nListenableCookieJar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListenableCookieJar.kt\nio/appwrite/cookies/ListenableCookieJar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1855#2,2:120\n*S KotlinDebug\n*F\n+ 1 ListenableCookieJar.kt\nio/appwrite/cookies/ListenableCookieJar\n*L\n28#1:120,2\n*E\n"})
public final class ListenableCookieJar
implements CookieJar {
    @NotNull
    private final CookieHandler cookieHandler;
    @NotNull
    private final Map<Integer, Function2<List<Cookie>, List<Cookie>, Unit>> listeners;

    public ListenableCookieJar(@NotNull CookieHandler cookieHandler) {
        Intrinsics.checkNotNullParameter((Object)cookieHandler, (String)"cookieHandler");
        this.cookieHandler = cookieHandler;
        this.listeners = new LinkedHashMap();
    }

    public final void onSave(@NotNull String key, @NotNull Function2<? super List<Cookie>, ? super List<Cookie>, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.listeners.put(key.hashCode(), listener);
    }

    public void saveFromResponse(@NotNull HttpUrl url, @NotNull List<Cookie> cookies) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
        List<Cookie> existingCookies = this.loadForRequest(url);
        Iterable $this$forEach$iv = this.listeners.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2 it = (Function2)element$iv;
            boolean bl = false;
            it.invoke(existingCookies, cookies);
        }
        List cookieStrings = new ArrayList();
        for (Cookie cookie : cookies) {
            cookieStrings.add(Internal.cookieToString((Cookie)cookie, (boolean)true));
        }
        Map multimap = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Set-Cookie", (Object)cookieStrings));
        try {
            this.cookieHandler.put(url.uri(), multimap);
        }
        catch (IOException e) {
            Platform platform = Platform.Companion.get();
            StringBuilder stringBuilder = new StringBuilder().append("Saving cookies failed for ");
            HttpUrl httpUrl = url.resolve("/...");
            Intrinsics.checkNotNull((Object)httpUrl);
            platform.log(stringBuilder.append(httpUrl).toString(), 5, (Throwable)e);
        }
    }

    @NotNull
    public List<Cookie> loadForRequest(@NotNull HttpUrl url) {
        Object object;
        Map<String, List<String>> map;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            map = this.cookieHandler.get(url.uri(), MapsKt.emptyMap());
        }
        catch (IOException e) {
            Platform platform = Platform.Companion.get();
            StringBuilder stringBuilder = new StringBuilder().append("Loading cookies failed for ");
            HttpUrl httpUrl = url.resolve("/...");
            Intrinsics.checkNotNull((Object)httpUrl);
            platform.log(stringBuilder.append(httpUrl).toString(), 5, (Throwable)e);
            return CollectionsKt.emptyList();
        }
        Map<String, List<String>> cookieHeaders = map;
        List cookies = null;
        Intrinsics.checkNotNull(cookieHeaders);
        for (Map.Entry<String, List<String>> entry : cookieHeaders.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            if (!StringsKt.equals((String)"Cookie", (String)key, (boolean)true) && !StringsKt.equals((String)"Cookie2", (String)key, (boolean)true)) continue;
            Intrinsics.checkNotNull(value);
            if (!(!((Collection)value).isEmpty())) continue;
            for (String header : value) {
                if (cookies == null) {
                    cookies = new ArrayList();
                }
                Intrinsics.checkNotNull((Object)header);
                cookies.addAll((Collection)this.decodeHeaderAsJavaNetCookies(url, header));
            }
        }
        if (cookies != null) {
            List list2 = Collections.unmodifiableList(cookies);
            Intrinsics.checkNotNull((Object)list2);
            object = list2;
        } else {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final List<Cookie> decodeHeaderAsJavaNetCookies(HttpUrl url, String header) {
        List result = new ArrayList();
        int pos = 0;
        int limit = header.length();
        int pairEnd = 0;
        while (pos < limit) {
            String value;
            pairEnd = Util.delimiterOffset((String)header, (String)";,", (int)pos, (int)limit);
            int equalsSign = Util.delimiterOffset((String)header, (char)'=', (int)pos, (int)pairEnd);
            String name = Util.trimSubstring((String)header, (int)pos, (int)equalsSign);
            if (StringsKt.startsWith$default((String)name, (String)"$", (boolean)false, (int)2, null)) {
                pos = pairEnd + 1;
                continue;
            }
            String string = value = equalsSign < pairEnd ? Util.trimSubstring((String)header, (int)(equalsSign + 1), (int)pairEnd) : "";
            if (StringsKt.startsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null)) {
                String string2 = value.substring(1, value.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                value = string2;
            }
            result.add(new Cookie.Builder().name(name).value(value).domain(url.host()).build());
            pos = pairEnd + 1;
        }
        return result;
    }
}

