/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.ImageView;
import androidx.annotation.MainThread;
import androidx.annotation.WorkerThread;
import androidx.lifecycle.Lifecycle;
import coil.decode.Options;
import coil.lifecycle.GlobalLifecycle;
import coil.lifecycle.LifecycleCoroutineDispatcher;
import coil.memory.HardwareBitmapService;
import coil.memory.RequestService$WhenMappings;
import coil.request.CachePolicy;
import coil.request.GetRequest;
import coil.request.LoadRequest;
import coil.request.Request;
import coil.size.DisplaySizeResolver;
import coil.size.Scale;
import coil.size.Size;
import coil.size.SizeResolver;
import coil.size.ViewSizeResolver;
import coil.target.Target;
import coil.target.ViewTarget;
import coil.transform.Transformation;
import coil.util.ContextsKt;
import coil.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0003J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0007J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0007J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcoil/memory/RequestService;", "", "()V", "hardwareBitmapService", "Lcoil/memory/HardwareBitmapService;", "allowInexactSize", "", "request", "Lcoil/request/Request;", "isConfigValidForHardware", "requestedConfig", "Landroid/graphics/Bitmap$Config;", "isConfigValidForHardwareAllocation", "size", "Lcoil/size/Size;", "isConfigValidForTransformations", "lifecycleInfo", "Lcoil/memory/RequestService$LifecycleInfo;", "options", "Lcoil/decode/Options;", "scale", "Lcoil/size/Scale;", "isOnline", "sizeResolver", "Lcoil/size/SizeResolver;", "context", "Landroid/content/Context;", "getLifecycle", "Landroidx/lifecycle/Lifecycle;", "Lcoil/request/LoadRequest;", "LifecycleInfo", "coil-base_release"})
public final class RequestService {
    private final HardwareBitmapService hardwareBitmapService = HardwareBitmapService.Companion.invoke();

    @MainThread
    @NotNull
    public final LifecycleInfo lifecycleInfo(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Request request2 = request;
        if (!(request2 instanceof GetRequest)) {
            if (request2 instanceof LoadRequest) {
                Lifecycle lifecycle = this.getLifecycle((LoadRequest)request);
                return lifecycle != null ? new LifecycleInfo(lifecycle, LifecycleCoroutineDispatcher.Companion.create((CoroutineDispatcher)Dispatchers.getMain().getImmediate(), lifecycle)) : LifecycleInfo.Companion.getGLOBAL();
            }
            throw new NoWhenBranchMatchedException();
        }
        return LifecycleInfo.Companion.getGLOBAL();
    }

    @NotNull
    public final SizeResolver sizeResolver(@NotNull Request request, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SizeResolver sizeResolver = request.getSizeResolver();
        Target target2 = request.getTarget();
        return sizeResolver != null ? sizeResolver : (target2 instanceof ViewTarget ? (SizeResolver)ViewSizeResolver.Companion.invoke$default(ViewSizeResolver.Companion, ((ViewTarget)target2).getView(), false, 2, null) : (SizeResolver)new DisplaySizeResolver(context));
    }

    @NotNull
    public final Scale scale(@NotNull Request request, @NotNull SizeResolver sizeResolver) {
        Object view;
        Object view2;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)sizeResolver, (String)"sizeResolver");
        Scale scale = request.getScale();
        if (scale != null) {
            return scale;
        }
        if (sizeResolver instanceof ViewSizeResolver && (view2 = ((ViewSizeResolver)sizeResolver).getView()) instanceof ImageView) {
            return ExtensionsKt.getScale((ImageView)view2);
        }
        Target target2 = request.getTarget();
        if (target2 instanceof ViewTarget && (view = ((ViewTarget)target2).getView()) instanceof ImageView) {
            return ExtensionsKt.getScale((ImageView)view);
        }
        return Scale.FILL;
    }

    public final boolean allowInexactSize(@NotNull Request request) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        switch (RequestService$WhenMappings.$EnumSwitchMapping$0[request.getPrecision().ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                Target target2 = request.getTarget();
                if (!(target2 instanceof ViewTarget)) {
                    target2 = null;
                }
                ViewTarget viewTarget = (ViewTarget)target2;
                if ((viewTarget != null ? viewTarget.getView() : null) instanceof ImageView) {
                    return true;
                }
                return request.getSizeResolver() == null && !(request.getTarget() instanceof ViewTarget);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @WorkerThread
    @NotNull
    public final Options options(@NotNull Request request, @NotNull Size size2, @NotNull Scale scale, boolean isOnline) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)size2, (String)"size");
        Intrinsics.checkParameterIsNotNull((Object)((Object)scale), (String)"scale");
        boolean isValidConfig = this.isConfigValidForTransformations(request) && this.isConfigValidForHardwareAllocation(request, size2);
        Bitmap.Config bitmapConfig = isValidConfig ? request.getBitmapConfig() : Bitmap.Config.ARGB_8888;
        CachePolicy networkCachePolicy = isOnline ? request.getNetworkCachePolicy() : CachePolicy.DISABLED;
        boolean allowRgb565 = request.getAllowRgb565() && request.getTransformations().isEmpty();
        CachePolicy cachePolicy = networkCachePolicy;
        CachePolicy cachePolicy2 = request.getDiskCachePolicy();
        return new Options(bitmapConfig, request.getColorSpace(), scale, this.allowInexactSize(request), allowRgb565, request.getHeaders(), request.getParameters(), cachePolicy, cachePolicy2);
    }

    public final boolean isConfigValidForHardware(@NotNull Request request, @NotNull Bitmap.Config requestedConfig) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)requestedConfig, (String)"requestedConfig");
        if (!ExtensionsKt.isHardware(requestedConfig)) {
            return true;
        }
        if (!request.getAllowHardware()) {
            return false;
        }
        Target target2 = request.getTarget();
        boolean bl = false;
        boolean bl2 = false;
        Target $this$run = target2;
        boolean bl3 = false;
        return !($this$run instanceof ViewTarget && !((ViewTarget)$this$run).getView().isHardwareAccelerated());
    }

    @WorkerThread
    private final boolean isConfigValidForHardwareAllocation(Request request, Size size2) {
        return this.isConfigValidForHardware(request, request.getBitmapConfig()) && this.hardwareBitmapService.allowHardware(size2);
    }

    private final boolean isConfigValidForTransformations(Request request) {
        return request.getTransformations().isEmpty() || ArraysKt.contains((Object[])Transformation.Companion.getVALID_CONFIGS$coil_base_release(), (Object)request.getBitmapConfig());
    }

    private final Lifecycle getLifecycle(@NotNull LoadRequest $this$getLifecycle) {
        Lifecycle lifecycle;
        if ($this$getLifecycle.getLifecycle() != null) {
            lifecycle = $this$getLifecycle.getLifecycle();
        } else if ($this$getLifecycle.getTarget() instanceof ViewTarget) {
            Context context = ((ViewTarget)$this$getLifecycle.getTarget()).getView().getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"target.view.context");
            lifecycle = ContextsKt.getLifecycle(context);
        } else {
            lifecycle = ContextsKt.getLifecycle($this$getLifecycle.getContext());
        }
        return lifecycle;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcoil/memory/RequestService$LifecycleInfo;", "", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "mainDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Landroidx/lifecycle/Lifecycle;Lkotlinx/coroutines/CoroutineDispatcher;)V", "getLifecycle", "()Landroidx/lifecycle/Lifecycle;", "getMainDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "coil-base_release"})
    public static final class LifecycleInfo {
        @NotNull
        private final Lifecycle lifecycle;
        @NotNull
        private final CoroutineDispatcher mainDispatcher;
        @NotNull
        private static final LifecycleInfo GLOBAL;
        public static final Companion Companion;

        @NotNull
        public final Lifecycle getLifecycle() {
            return this.lifecycle;
        }

        @NotNull
        public final CoroutineDispatcher getMainDispatcher() {
            return this.mainDispatcher;
        }

        public LifecycleInfo(@NotNull Lifecycle lifecycle, @NotNull CoroutineDispatcher mainDispatcher) {
            Intrinsics.checkParameterIsNotNull((Object)lifecycle, (String)"lifecycle");
            Intrinsics.checkParameterIsNotNull((Object)mainDispatcher, (String)"mainDispatcher");
            this.lifecycle = lifecycle;
            this.mainDispatcher = mainDispatcher;
        }

        static {
            Companion = new Companion(null);
            GLOBAL = new LifecycleInfo(GlobalLifecycle.INSTANCE, (CoroutineDispatcher)Dispatchers.getMain().getImmediate());
        }

        @NotNull
        public final Lifecycle component1() {
            return this.lifecycle;
        }

        @NotNull
        public final CoroutineDispatcher component2() {
            return this.mainDispatcher;
        }

        @NotNull
        public final LifecycleInfo copy(@NotNull Lifecycle lifecycle, @NotNull CoroutineDispatcher mainDispatcher) {
            Intrinsics.checkParameterIsNotNull((Object)lifecycle, (String)"lifecycle");
            Intrinsics.checkParameterIsNotNull((Object)mainDispatcher, (String)"mainDispatcher");
            return new LifecycleInfo(lifecycle, mainDispatcher);
        }

        public static /* synthetic */ LifecycleInfo copy$default(LifecycleInfo lifecycleInfo, Lifecycle lifecycle, CoroutineDispatcher coroutineDispatcher, int n, Object object) {
            if ((n & 1) != 0) {
                lifecycle = lifecycleInfo.lifecycle;
            }
            if ((n & 2) != 0) {
                coroutineDispatcher = lifecycleInfo.mainDispatcher;
            }
            return lifecycleInfo.copy(lifecycle, coroutineDispatcher);
        }

        @NotNull
        public String toString() {
            return "LifecycleInfo(lifecycle=" + this.lifecycle + ", mainDispatcher=" + this.mainDispatcher + ")";
        }

        public int hashCode() {
            Lifecycle lifecycle = this.lifecycle;
            CoroutineDispatcher coroutineDispatcher = this.mainDispatcher;
            return (lifecycle != null ? lifecycle.hashCode() : 0) * 31 + (coroutineDispatcher != null ? coroutineDispatcher.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LifecycleInfo)) break block3;
                    LifecycleInfo lifecycleInfo = (LifecycleInfo)object;
                    if (!Intrinsics.areEqual((Object)this.lifecycle, (Object)lifecycleInfo.lifecycle) || !Intrinsics.areEqual((Object)this.mainDispatcher, (Object)lifecycleInfo.mainDispatcher)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcoil/memory/RequestService$LifecycleInfo$Companion;", "", "()V", "GLOBAL", "Lcoil/memory/RequestService$LifecycleInfo;", "getGLOBAL", "()Lcoil/memory/RequestService$LifecycleInfo;", "coil-base_release"})
        public static final class Companion {
            @NotNull
            public final LifecycleInfo getGLOBAL() {
                return GLOBAL;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

