/*
 * Decompiled with CFR 0.152.
 */
package coil.target;

import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import coil.target.PoolableViewTarget;
import coil.transition.TransitionTarget;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0012\u0010\u001a\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\b\u0010\u001b\u001a\u00020\u0010H\u0014R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcoil/target/ImageViewTarget;", "Lcoil/target/PoolableViewTarget;", "Landroid/widget/ImageView;", "Lcoil/transition/TransitionTarget;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "view", "(Landroid/widget/ImageView;)V", "drawable", "Landroid/graphics/drawable/Drawable;", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "isStarted", "", "getView", "()Landroid/widget/ImageView;", "onClear", "", "onError", "error", "onStart", "placeholder", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onStop", "onSuccess", "result", "setDrawable", "updateAnimation", "coil-base_release"})
public class ImageViewTarget
implements PoolableViewTarget<ImageView>,
TransitionTarget<ImageView>,
DefaultLifecycleObserver {
    private boolean isStarted;
    @NotNull
    private final ImageView view;

    @Override
    @Nullable
    public Drawable getDrawable() {
        return this.getView().getDrawable();
    }

    @Override
    public void onStart(@Nullable Drawable placeholder) {
        this.setDrawable(placeholder);
    }

    @Override
    public void onSuccess(@NotNull Drawable result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        this.setDrawable(result);
    }

    @Override
    public void onError(@Nullable Drawable error2) {
        this.setDrawable(error2);
    }

    @Override
    public void onClear() {
        this.setDrawable(null);
    }

    public void onStart(@NotNull LifecycleOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        this.isStarted = true;
        this.updateAnimation();
    }

    public void onStop(@NotNull LifecycleOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        this.isStarted = false;
        this.updateAnimation();
    }

    protected void setDrawable(@Nullable Drawable drawable) {
        Drawable drawable2 = this.getView().getDrawable();
        if (!(drawable2 instanceof Animatable)) {
            drawable2 = null;
        }
        Animatable animatable = (Animatable)drawable2;
        if (animatable != null) {
            animatable.stop();
        }
        this.getView().setImageDrawable(drawable);
        this.updateAnimation();
    }

    protected void updateAnimation() {
        Drawable drawable = this.getView().getDrawable();
        if (!(drawable instanceof Animatable)) {
            drawable = null;
        }
        Animatable animatable = (Animatable)drawable;
        if (animatable == null) {
            return;
        }
        Animatable animatable2 = animatable;
        if (this.isStarted) {
            animatable2.start();
        } else {
            animatable2.stop();
        }
    }

    @Override
    @NotNull
    public ImageView getView() {
        return this.view;
    }

    public ImageViewTarget(@NotNull ImageView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.view = view;
    }
}

