/*
 * Decompiled with CFR 0.152.
 */
package coil.bitmap;

import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.Px;
import coil.bitmap.BitmapPool;
import coil.bitmap.BitmapPoolStrategy;
import coil.util.-Bitmaps;
import coil.util.Logger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\t\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J$\u0010\u0018\u001a\u00020\u000e2\b\b\u0001\u0010\u0019\u001a\u00020\u00032\b\b\u0001\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J$\u0010\u001c\u001a\u00020\u000e2\b\b\u0001\u0010\u0019\u001a\u00020\u00032\b\b\u0001\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J&\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010\u0019\u001a\u00020\u00032\b\b\u0001\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J&\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010\u0019\u001a\u00020\u00032\b\b\u0001\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u000eH\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u000eH\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0003H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcoil/bitmap/RealBitmapPool;", "Lcoil/bitmap/BitmapPool;", "maxSize", "", "allowedConfigs", "", "Landroid/graphics/Bitmap$Config;", "strategy", "Lcoil/bitmap/BitmapPoolStrategy;", "logger", "Lcoil/util/Logger;", "(ILjava/util/Set;Lcoil/bitmap/BitmapPoolStrategy;Lcoil/util/Logger;)V", "bitmaps", "Ljava/util/HashSet;", "Landroid/graphics/Bitmap;", "Lkotlin/collections/HashSet;", "currentSize", "evictions", "hits", "misses", "puts", "clear", "", "clearMemory", "get", "width", "height", "config", "getDirty", "getDirtyOrNull", "getOrNull", "logStats", "", "normalize", "bitmap", "put", "trimMemory", "level", "trimToSize", "size", "Companion", "coil-base_release"})
public final class RealBitmapPool
implements BitmapPool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxSize;
    @NotNull
    private final Set<Bitmap.Config> allowedConfigs;
    @NotNull
    private final BitmapPoolStrategy strategy;
    @Nullable
    private final Logger logger;
    @NotNull
    private final HashSet<Bitmap> bitmaps;
    private int currentSize;
    private int hits;
    private int misses;
    private int puts;
    private int evictions;
    @NotNull
    private static final String TAG = "RealBitmapPool";
    @NotNull
    private static final Set<Bitmap.Config> ALLOWED_CONFIGS;

    public RealBitmapPool(int maxSize, @NotNull Set<? extends Bitmap.Config> allowedConfigs, @NotNull BitmapPoolStrategy strategy, @Nullable Logger logger) {
        Intrinsics.checkNotNullParameter(allowedConfigs, (String)"allowedConfigs");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        this.maxSize = maxSize;
        this.allowedConfigs = allowedConfigs;
        this.strategy = strategy;
        this.logger = logger;
        boolean bl = false;
        this.bitmaps = new HashSet();
        bl = this.maxSize >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "maxSize must be >= 0.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ RealBitmapPool(int n, Set set, BitmapPoolStrategy bitmapPoolStrategy, Logger logger, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            set = ALLOWED_CONFIGS;
        }
        if ((n2 & 4) != 0) {
            bitmapPoolStrategy = BitmapPoolStrategy.Companion.invoke();
        }
        if ((n2 & 8) != 0) {
            logger = null;
        }
        this(n, set, bitmapPoolStrategy, logger);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void put(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        if (bitmap.isRecycled()) {
            Logger logger = this.logger;
            if (logger != null) {
                void $this$log$iv;
                Logger logger2 = logger;
                String string = TAG;
                int priority$iv = 6;
                boolean $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv) {
                    void tag$iv;
                    int n = priority$iv;
                    void var10_27 = tag$iv;
                    void var9_31 = $this$log$iv;
                    boolean bl = false;
                    String string2 = Intrinsics.stringPlus((String)"Rejecting recycled bitmap from pool; bitmap: ", (Object)bitmap);
                    var9_31.log((String)var10_27, n, string2, null);
                }
            }
            return;
        }
        int size2 = -Bitmaps.getAllocationByteCountCompat(bitmap);
        if (!bitmap.isMutable() || size2 > this.maxSize || !this.allowedConfigs.contains(bitmap.getConfig())) {
            Logger logger = this.logger;
            if (logger != null) {
                void $this$log$iv;
                Logger tag$iv = logger;
                String priority$iv = TAG;
                int priority$iv2 = 2;
                boolean $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv2) {
                    void tag$iv2;
                    int n = priority$iv2;
                    void var10_28 = tag$iv2;
                    void var9_32 = $this$log$iv;
                    boolean bl = false;
                    String string = "Rejecting bitmap from pool; bitmap: " + this.strategy.stringify(bitmap) + ", is mutable: " + bitmap.isMutable() + ", is greater than max size: " + (size2 > this.maxSize) + ", is allowed config: " + this.allowedConfigs.contains(bitmap.getConfig());
                    var9_32.log((String)var10_28, n, string, null);
                }
            }
            bitmap.recycle();
            return;
        }
        if (this.bitmaps.contains(bitmap)) {
            Logger logger = this.logger;
            if (logger != null) {
                Logger $this$log$iv = logger;
                String tag$iv2 = TAG;
                int priority$iv = 6;
                boolean $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv) {
                    int n = priority$iv;
                    String string = tag$iv2;
                    Logger logger3 = $this$log$iv;
                    boolean bl = false;
                    String string3 = Intrinsics.stringPlus((String)"Rejecting duplicate bitmap from pool; bitmap: ", (Object)this.strategy.stringify(bitmap));
                    logger3.log(string, n, string3, null);
                }
            }
            return;
        }
        this.strategy.put(bitmap);
        Object object = this;
        Collection $this$log$iv222 = ((RealBitmapPool)object).bitmaps;
        boolean tag$iv3 = false;
        $this$log$iv222.add(bitmap);
        object = this;
        ((RealBitmapPool)object).currentSize += size2;
        object = this;
        int $this$log$iv222 = ((RealBitmapPool)object).puts;
        ((RealBitmapPool)object).puts = $this$log$iv222 + 1;
        object = this.logger;
        if (object != null) {
            Object $this$log$iv222 = object;
            String tag$iv3 = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv222.getLevel() <= priority$iv) {
                int n = priority$iv;
                String string = tag$iv3;
                Object object2 = $this$log$iv222;
                boolean bl = false;
                String string4 = "Put bitmap=" + this.strategy.stringify(bitmap) + '\n' + this.logStats();
                object2.log(string, n, string4, null);
            }
        }
        this.trimToSize(this.maxSize);
    }

    @Override
    @NotNull
    public Bitmap get(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Bitmap bitmap2 = this.getOrNull(width, height, config);
        if (bitmap2 == null) {
            boolean $i$f$createBitmap = false;
            Bitmap bitmap3 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            bitmap = bitmap3;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"Bitmap.createBitmap(width, height, config)");
        } else {
            bitmap = bitmap2;
        }
        return bitmap;
    }

    @Override
    @Nullable
    public Bitmap getOrNull(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Bitmap bitmap2 = this.getDirtyOrNull(width, height, config);
        if (bitmap2 == null) {
            bitmap = null;
        } else {
            Bitmap bitmap3 = bitmap2;
            boolean bl = false;
            boolean bl2 = false;
            Bitmap $this$getOrNull_u24lambda_u2d5 = bitmap3;
            boolean bl3 = false;
            $this$getOrNull_u24lambda_u2d5.eraseColor(0);
            bitmap = bitmap3;
        }
        return bitmap;
    }

    @Override
    @NotNull
    public Bitmap getDirty(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Bitmap bitmap2 = this.getDirtyOrNull(width, height, config);
        if (bitmap2 == null) {
            boolean $i$f$createBitmap = false;
            Bitmap bitmap3 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            bitmap = bitmap3;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"Bitmap.createBitmap(width, height, config)");
        } else {
            bitmap = bitmap2;
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public synchronized Bitmap getDirtyOrNull(@Px int width, @Px int height, @NotNull Bitmap.Config config) {
        int $this$log$iv22;
        String string;
        Object object;
        String string2;
        int n;
        boolean $i$f$log;
        int priority$iv;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean bl = !-Bitmaps.isHardware(config);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string3 = "Cannot create a mutable hardware bitmap.";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        Bitmap result = this.strategy.get(width, height, config);
        if (result == null) {
            object2 = this.logger;
            if (object2 != null) {
                void $this$log$iv22;
                Object object3 = object2;
                String bl4 = TAG;
                priority$iv = 2;
                $i$f$log = false;
                if ($this$log$iv22.getLevel() <= priority$iv) {
                    void tag$iv;
                    n = priority$iv;
                    string2 = tag$iv;
                    object = $this$log$iv22;
                    boolean bl5 = false;
                    string = Intrinsics.stringPlus((String)"Missing bitmap=", (Object)this.strategy.stringify(width, height, config));
                    object.log(string2, n, string, null);
                }
            }
            object2 = this;
            $this$log$iv22 = ((RealBitmapPool)object2).misses;
            ((RealBitmapPool)object2).misses = $this$log$iv22 + 1;
        } else {
            object2 = this;
            Collection $this$log$iv22 = ((RealBitmapPool)object2).bitmaps;
            boolean tag$iv = false;
            $this$log$iv22.remove(result);
            object2 = this;
            ((RealBitmapPool)object2).currentSize -= -Bitmaps.getAllocationByteCountCompat(result);
            object2 = this;
            $this$log$iv22 = ((RealBitmapPool)object2).hits;
            ((RealBitmapPool)object2).hits = $this$log$iv22 + 1;
            this.normalize(result);
        }
        object2 = this.logger;
        if (object2 != null) {
            Object $this$log$iv22 = object2;
            String tag$iv = TAG;
            priority$iv = 2;
            $i$f$log = false;
            if ($this$log$iv22.getLevel() <= priority$iv) {
                n = priority$iv;
                string2 = tag$iv;
                object = $this$log$iv22;
                boolean bl6 = false;
                string = "Get bitmap=" + this.strategy.stringify(width, height, config) + '\n' + this.logStats();
                object.log(string2, n, string, null);
            }
        }
        return result;
    }

    @Override
    public void clear() {
        this.clearMemory();
    }

    /*
     * WARNING - void declaration
     */
    public final void clearMemory() {
        Logger logger = this.logger;
        if (logger != null) {
            void $this$log$iv;
            Logger logger2 = logger;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var8_7 = tag$iv;
                void var7_8 = $this$log$iv;
                boolean bl = false;
                String string2 = "clearMemory";
                var7_8.log((String)var8_7, n, string2, null);
            }
        }
        this.trimToSize(-1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void trimMemory(int level) {
        Logger logger = this.logger;
        if (logger != null) {
            void $this$log$iv;
            Logger logger2 = logger;
            String string = TAG;
            int priority$iv = 2;
            boolean $i$f$log = false;
            if ($this$log$iv.getLevel() <= priority$iv) {
                void tag$iv;
                int n = priority$iv;
                void var9_8 = tag$iv;
                void var8_9 = $this$log$iv;
                boolean bl = false;
                String string2 = Intrinsics.stringPlus((String)"trimMemory, level=", (Object)level);
                var8_9.log((String)var9_8, n, string2, null);
            }
        }
        if (level >= 40) {
            this.clearMemory();
        } else {
            boolean bl = 10 <= level ? level < 20 : false;
            if (bl) {
                this.trimToSize(this.currentSize / 2);
            }
        }
    }

    private final void normalize(Bitmap bitmap) {
        bitmap.setDensity(0);
        bitmap.setHasAlpha(true);
        if (Build.VERSION.SDK_INT >= 19) {
            bitmap.setPremultiplied(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void trimToSize(int size2) {
        while (this.currentSize > size2) {
            String string;
            Object object;
            String string2;
            int n;
            boolean $i$f$log;
            int priority$iv;
            Object object2;
            Bitmap removed = this.strategy.removeLast();
            if (removed == null) {
                object2 = this.logger;
                if (object2 != null) {
                    void $this$log$iv222;
                    Object object3 = object2;
                    String string3 = TAG;
                    priority$iv = 5;
                    $i$f$log = false;
                    if ($this$log$iv222.getLevel() <= priority$iv) {
                        void tag$iv2;
                        n = priority$iv;
                        string2 = tag$iv2;
                        object = $this$log$iv222;
                        boolean bl = false;
                        string = Intrinsics.stringPlus((String)"Size mismatch, resetting.\n", (Object)this.logStats());
                        object.log(string2, n, string, null);
                    }
                }
                this.currentSize = 0;
                return;
            }
            object2 = this;
            Collection $this$log$iv222 = ((RealBitmapPool)object2).bitmaps;
            boolean tag$iv2 = false;
            $this$log$iv222.remove(removed);
            object2 = this;
            ((RealBitmapPool)object2).currentSize -= -Bitmaps.getAllocationByteCountCompat(removed);
            object2 = this;
            int $this$log$iv222 = ((RealBitmapPool)object2).evictions;
            ((RealBitmapPool)object2).evictions = $this$log$iv222 + 1;
            object2 = this.logger;
            if (object2 != null) {
                Object $this$log$iv222 = object2;
                String tag$iv2 = TAG;
                priority$iv = 2;
                $i$f$log = false;
                if ($this$log$iv222.getLevel() <= priority$iv) {
                    n = priority$iv;
                    string2 = tag$iv2;
                    object = $this$log$iv222;
                    boolean bl = false;
                    string = "Evicting bitmap=" + this.strategy.stringify(removed) + '\n' + this.logStats();
                    object.log(string2, n, string, null);
                }
            }
            removed.recycle();
        }
    }

    private final String logStats() {
        return "Hits=" + this.hits + ", misses=" + this.misses + ", puts=" + this.puts + ", evictions=" + this.evictions + ", currentSize=" + this.currentSize + ", maxSize=" + this.maxSize + ", strategy=" + this.strategy;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        Set set = SetsKt.createSetBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        Set $this$ALLOWED_CONFIGS_u24lambda_u2d13 = set;
        boolean bl5 = false;
        $this$ALLOWED_CONFIGS_u24lambda_u2d13.add(Bitmap.Config.ALPHA_8);
        $this$ALLOWED_CONFIGS_u24lambda_u2d13.add(Bitmap.Config.RGB_565);
        $this$ALLOWED_CONFIGS_u24lambda_u2d13.add(Bitmap.Config.ARGB_4444);
        $this$ALLOWED_CONFIGS_u24lambda_u2d13.add(Bitmap.Config.ARGB_8888);
        if (Build.VERSION.SDK_INT >= 26) {
            $this$ALLOWED_CONFIGS_u24lambda_u2d13.add(Bitmap.Config.RGBA_F16);
        }
        ALLOWED_CONFIGS = SetsKt.build((Set)set);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcoil/bitmap/RealBitmapPool$Companion;", "", "()V", "ALLOWED_CONFIGS", "", "Landroid/graphics/Bitmap$Config;", "getALLOWED_CONFIGS$annotations", "TAG", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getALLOWED_CONFIGS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

