/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.graphics.Bitmap;
import coil.bitmap.BitmapPool;
import coil.bitmap.BitmapReferenceCounter;
import coil.memory.MemoryCache;
import coil.memory.StrongMemoryCache;
import coil.memory.WeakMemoryCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001#B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0096\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0019\u0010!\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001cH\u0096\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lcoil/memory/RealMemoryCache;", "Lcoil/memory/MemoryCache;", "strongMemoryCache", "Lcoil/memory/StrongMemoryCache;", "weakMemoryCache", "Lcoil/memory/WeakMemoryCache;", "referenceCounter", "Lcoil/bitmap/BitmapReferenceCounter;", "bitmapPool", "Lcoil/bitmap/BitmapPool;", "(Lcoil/memory/StrongMemoryCache;Lcoil/memory/WeakMemoryCache;Lcoil/bitmap/BitmapReferenceCounter;Lcoil/bitmap/BitmapPool;)V", "getBitmapPool", "()Lcoil/bitmap/BitmapPool;", "maxSize", "", "getMaxSize", "()I", "getReferenceCounter", "()Lcoil/bitmap/BitmapReferenceCounter;", "size", "getSize", "getStrongMemoryCache", "()Lcoil/memory/StrongMemoryCache;", "getWeakMemoryCache", "()Lcoil/memory/WeakMemoryCache;", "clear", "", "get", "Landroid/graphics/Bitmap;", "key", "Lcoil/memory/MemoryCache$Key;", "remove", "", "set", "bitmap", "Value", "coil-base_release"})
public final class RealMemoryCache
implements MemoryCache {
    @NotNull
    private final StrongMemoryCache strongMemoryCache;
    @NotNull
    private final WeakMemoryCache weakMemoryCache;
    @NotNull
    private final BitmapReferenceCounter referenceCounter;
    @NotNull
    private final BitmapPool bitmapPool;

    public RealMemoryCache(@NotNull StrongMemoryCache strongMemoryCache, @NotNull WeakMemoryCache weakMemoryCache, @NotNull BitmapReferenceCounter referenceCounter, @NotNull BitmapPool bitmapPool) {
        Intrinsics.checkNotNullParameter((Object)strongMemoryCache, (String)"strongMemoryCache");
        Intrinsics.checkNotNullParameter((Object)weakMemoryCache, (String)"weakMemoryCache");
        Intrinsics.checkNotNullParameter((Object)referenceCounter, (String)"referenceCounter");
        Intrinsics.checkNotNullParameter((Object)bitmapPool, (String)"bitmapPool");
        this.strongMemoryCache = strongMemoryCache;
        this.weakMemoryCache = weakMemoryCache;
        this.referenceCounter = referenceCounter;
        this.bitmapPool = bitmapPool;
    }

    @NotNull
    public final StrongMemoryCache getStrongMemoryCache() {
        return this.strongMemoryCache;
    }

    @NotNull
    public final WeakMemoryCache getWeakMemoryCache() {
        return this.weakMemoryCache;
    }

    @NotNull
    public final BitmapReferenceCounter getReferenceCounter() {
        return this.referenceCounter;
    }

    @NotNull
    public final BitmapPool getBitmapPool() {
        return this.bitmapPool;
    }

    @Override
    public int getSize() {
        return this.strongMemoryCache.getSize();
    }

    @Override
    public int getMaxSize() {
        return this.strongMemoryCache.getMaxSize();
    }

    @Override
    @Nullable
    public Bitmap get(@NotNull MemoryCache.Key key) {
        Bitmap bitmap;
        Value value;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Value value2 = this.strongMemoryCache.get(key);
        value2 = value = value2 == null ? this.weakMemoryCache.get(key) : value2;
        if (value2 == null) {
            bitmap = null;
        } else {
            Bitmap bitmap2;
            Bitmap bitmap3 = bitmap2 = value2.getBitmap();
            boolean bl = false;
            boolean bl2 = false;
            Bitmap it = bitmap3;
            boolean bl3 = false;
            this.getReferenceCounter().setValid(it, false);
            bitmap = bitmap3;
        }
        return bitmap;
    }

    @Override
    public void set(@NotNull MemoryCache.Key key, @NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.referenceCounter.setValid(bitmap, false);
        this.strongMemoryCache.set(key, bitmap, false);
        this.weakMemoryCache.remove(key);
    }

    @Override
    public boolean remove(@NotNull MemoryCache.Key key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean removedStrong = this.strongMemoryCache.remove(key);
        boolean removedWeak = this.weakMemoryCache.remove(key);
        return removedStrong || removedWeak;
    }

    @Override
    public void clear() {
        this.strongMemoryCache.clearMemory();
        this.weakMemoryCache.clearMemory();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\t"}, d2={"Lcoil/memory/RealMemoryCache$Value;", "", "bitmap", "Landroid/graphics/Bitmap;", "getBitmap", "()Landroid/graphics/Bitmap;", "isSampled", "", "()Z", "coil-base_release"})
    public static interface Value {
        @NotNull
        public Bitmap getBitmap();

        public boolean isSampled();
    }
}

