/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.WorkerThread;
import androidx.core.view.ViewCompat;
import coil.decode.Options;
import coil.memory.HardwareBitmapService;
import coil.request.CachePolicy;
import coil.request.ErrorResult;
import coil.request.ImageRequest;
import coil.request.NullRequestDataException;
import coil.size.Size;
import coil.target.Target;
import coil.target.ViewTarget;
import coil.util.-Bitmaps;
import coil.util.-Requests;
import coil.util.Logger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000eH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcoil/memory/RequestService;", "", "logger", "Lcoil/util/Logger;", "(Lcoil/util/Logger;)V", "hardwareBitmapService", "Lcoil/memory/HardwareBitmapService;", "errorResult", "Lcoil/request/ErrorResult;", "request", "Lcoil/request/ImageRequest;", "throwable", "", "isConfigValidForHardware", "", "requestedConfig", "Landroid/graphics/Bitmap$Config;", "isConfigValidForHardwareAllocation", "size", "Lcoil/size/Size;", "isConfigValidForTransformations", "options", "Lcoil/decode/Options;", "isOnline", "Companion", "coil-base_release"})
public final class RequestService {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final Logger logger;
    @NotNull
    private final HardwareBitmapService hardwareBitmapService;
    @JvmField
    @NotNull
    public static final Bitmap.Config[] VALID_TRANSFORMATION_CONFIGS;

    public RequestService(@Nullable Logger logger) {
        this.logger = logger;
        this.hardwareBitmapService = HardwareBitmapService.Companion.invoke();
    }

    @NotNull
    public final ErrorResult errorResult(@NotNull ImageRequest request, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        return new ErrorResult(throwable instanceof NullRequestDataException ? request.getFallback() : request.getError(), request, throwable);
    }

    @WorkerThread
    @NotNull
    public final Options options(@NotNull ImageRequest request, @NotNull Size size2, boolean isOnline) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        boolean isValidConfig = this.isConfigValidForTransformations(request) && this.isConfigValidForHardwareAllocation(request, size2);
        Bitmap.Config config = isValidConfig ? request.getBitmapConfig() : Bitmap.Config.ARGB_8888;
        CachePolicy networkCachePolicy = isOnline ? request.getNetworkCachePolicy() : CachePolicy.DISABLED;
        boolean allowRgb565 = request.getAllowRgb565() && request.getTransformations().isEmpty() && config != Bitmap.Config.ALPHA_8;
        return new Options(request.getContext(), config, request.getColorSpace(), request.getScale(), -Requests.getAllowInexactSize(request), allowRgb565, request.getPremultipliedAlpha(), request.getHeaders(), request.getParameters(), request.getMemoryCachePolicy(), request.getDiskCachePolicy(), networkCachePolicy);
    }

    public final boolean isConfigValidForHardware(@NotNull ImageRequest request, @NotNull Bitmap.Config requestedConfig) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestedConfig, (String)"requestedConfig");
        if (!-Bitmaps.isHardware(requestedConfig)) {
            return true;
        }
        if (!request.getAllowHardware()) {
            return false;
        }
        Target target2 = request.getTarget();
        if (target2 instanceof ViewTarget) {
            Object t = ((ViewTarget)target2).getView();
            boolean bl = false;
            boolean bl2 = false;
            Object $this$isConfigValidForHardware_u24lambda_u2d0 = t;
            boolean bl3 = false;
            Object $this$isAttachedToWindowCompat$iv = $this$isConfigValidForHardware_u24lambda_u2d0;
            boolean $i$f$isAttachedToWindowCompat = false;
            boolean bl4 = ViewCompat.isAttachedToWindow($this$isAttachedToWindowCompat$iv) && !$this$isConfigValidForHardware_u24lambda_u2d0.isHardwareAccelerated();
            if (bl4) {
                return false;
            }
        }
        return true;
    }

    @WorkerThread
    private final boolean isConfigValidForHardwareAllocation(ImageRequest request, Size size2) {
        return this.isConfigValidForHardware(request, request.getBitmapConfig()) && this.hardwareBitmapService.allowHardware(size2, this.logger);
    }

    private final boolean isConfigValidForTransformations(ImageRequest request) {
        return request.getTransformations().isEmpty() || ArraysKt.contains((Object[])VALID_TRANSFORMATION_CONFIGS, (Object)request.getBitmapConfig());
    }

    static {
        Bitmap.Config[] configArray;
        Companion = new Companion(null);
        if (Build.VERSION.SDK_INT >= 26) {
            Bitmap.Config[] configArray2 = new Bitmap.Config[]{Bitmap.Config.ARGB_8888, Bitmap.Config.RGBA_F16};
            configArray = configArray2;
        } else {
            Bitmap.Config[] configArray3 = new Bitmap.Config[]{Bitmap.Config.ARGB_8888};
            configArray = configArray3;
        }
        VALID_TRANSFORMATION_CONFIGS = configArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcoil/memory/RequestService$Companion;", "", "()V", "VALID_TRANSFORMATION_CONFIGS", "", "Landroid/graphics/Bitmap$Config;", "[Landroid/graphics/Bitmap$Config;", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

