/*
 * Decompiled with CFR 0.152.
 */
package coil.map;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import androidx.annotation.DrawableRes;
import coil.map.Mapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u0002H\u0016J\u0012\u0010\n\u001a\u00020\u00032\b\b\u0001\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcoil/map/ResourceIntMapper;", "Lcoil/map/Mapper;", "", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "handles", "", "data", "map", "coil-base_release"})
public final class ResourceIntMapper
implements Mapper<Integer, Uri> {
    @NotNull
    private final Context context;

    public ResourceIntMapper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    public boolean handles(@DrawableRes int data) {
        boolean bl;
        try {
            bl = this.context.getResources().getResourceEntryName(data) != null;
        }
        catch (Resources.NotFoundException _) {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public Uri map(@DrawableRes int data) {
        String $this$toUri$iv = "android.resource://" + this.context.getPackageName() + '/' + data;
        boolean $i$f$toUri = false;
        Uri uri = Uri.parse((String)$this$toUri$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(this)");
        return uri;
    }
}

