/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import androidx.exifinterface.media.ExifInterface;
import coil.decode.ExifData;
import coil.decode.ExifInterfaceInputStream;
import coil.decode.ExifOrientationPolicy;
import coil.decode.ExifUtilsKt;
import coil.util.-Bitmaps;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcoil/decode/ExifUtils;", "", "()V", "PAINT", "Landroid/graphics/Paint;", "getExifData", "Lcoil/decode/ExifData;", "mimeType", "", "source", "Lokio/BufferedSource;", "policy", "Lcoil/decode/ExifOrientationPolicy;", "reverseTransformations", "Landroid/graphics/Bitmap;", "inBitmap", "exifData", "coil-base_release"})
public final class ExifUtils {
    @NotNull
    public static final ExifUtils INSTANCE = new ExifUtils();
    @NotNull
    private static final Paint PAINT = new Paint(3);

    private ExifUtils() {
    }

    @NotNull
    public final ExifData getExifData(@Nullable String mimeType, @NotNull BufferedSource source, @NotNull ExifOrientationPolicy policy) {
        if (ExifUtilsKt.supports(policy, mimeType)) {
            ExifInterface exifInterface = new ExifInterface((InputStream)new ExifInterfaceInputStream(source.peek().inputStream()));
            return new ExifData(exifInterface.isFlipped(), exifInterface.getRotationDegrees());
        }
        return ExifData.NONE;
    }

    @NotNull
    public final Bitmap reverseTransformations(@NotNull Bitmap inBitmap, @NotNull ExifData exifData) {
        Canvas c$iv;
        Bitmap outBitmap;
        Bitmap bitmap;
        int height$iv;
        int width$iv;
        boolean $i$f$createBitmap;
        Bitmap.Config config$iv;
        if (!exifData.isFlipped() && !ExifUtilsKt.isRotated(exifData)) {
            return inBitmap;
        }
        Matrix matrix = new Matrix();
        float centerX = (float)inBitmap.getWidth() / 2.0f;
        float centerY = (float)inBitmap.getHeight() / 2.0f;
        if (exifData.isFlipped()) {
            matrix.postScale(-1.0f, 1.0f, centerX, centerY);
        }
        if (ExifUtilsKt.isRotated(exifData)) {
            matrix.postRotate((float)exifData.getRotationDegrees(), centerX, centerY);
        }
        RectF rect = new RectF(0.0f, 0.0f, (float)inBitmap.getWidth(), (float)inBitmap.getHeight());
        matrix.mapRect(rect);
        if (!(rect.left == 0.0f) || !(rect.top == 0.0f)) {
            matrix.postTranslate(-rect.left, -rect.top);
        }
        if (ExifUtilsKt.isSwapped(exifData)) {
            int n = inBitmap.getHeight();
            int n2 = inBitmap.getWidth();
            config$iv = -Bitmaps.getSafeConfig(inBitmap);
            $i$f$createBitmap = false;
            Bitmap bitmap2 = Bitmap.createBitmap((int)width$iv, (int)height$iv, (Bitmap.Config)config$iv);
            bitmap = bitmap2;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(width, height, config)");
        } else {
            width$iv = inBitmap.getWidth();
            height$iv = inBitmap.getHeight();
            config$iv = -Bitmaps.getSafeConfig(inBitmap);
            $i$f$createBitmap = false;
            Bitmap bitmap3 = Bitmap.createBitmap((int)width$iv, (int)height$iv, (Bitmap.Config)config$iv);
            bitmap = bitmap3;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(width, height, config)");
        }
        Bitmap $this$applyCanvas$iv = outBitmap = bitmap;
        boolean $i$f$applyCanvas = false;
        Canvas $this$reverseTransformations_u24lambda_u2d0 = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl = false;
        $this$reverseTransformations_u24lambda_u2d0.drawBitmap(inBitmap, matrix, PAINT);
        inBitmap.recycle();
        return outBitmap;
    }
}

