/*
 * Decompiled with CFR 0.152.
 */
package coil.request;

import androidx.annotation.MainThread;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import coil.ImageLoader;
import coil.request.ImageRequest;
import coil.request.RequestDelegate;
import coil.target.ViewTarget;
import coil.util.-Lifecycles;
import coil.util.-Utils;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0007J\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcoil/request/ViewTargetRequestDelegate;", "Lcoil/request/RequestDelegate;", "imageLoader", "Lcoil/ImageLoader;", "initialRequest", "Lcoil/request/ImageRequest;", "target", "Lcoil/target/ViewTarget;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "job", "Lkotlinx/coroutines/Job;", "(Lcoil/ImageLoader;Lcoil/request/ImageRequest;Lcoil/target/ViewTarget;Landroidx/lifecycle/Lifecycle;Lkotlinx/coroutines/Job;)V", "assertActive", "", "dispose", "onDestroy", "owner", "Landroidx/lifecycle/LifecycleOwner;", "restart", "start", "coil-base_release"})
public final class ViewTargetRequestDelegate
extends RequestDelegate {
    @NotNull
    private final ImageLoader imageLoader;
    @NotNull
    private final ImageRequest initialRequest;
    @NotNull
    private final ViewTarget<?> target;
    @NotNull
    private final Lifecycle lifecycle;
    @NotNull
    private final Job job;

    public ViewTargetRequestDelegate(@NotNull ImageLoader imageLoader, @NotNull ImageRequest initialRequest, @NotNull ViewTarget<?> target2, @NotNull Lifecycle lifecycle, @NotNull Job job2) {
        super(null);
        this.imageLoader = imageLoader;
        this.initialRequest = initialRequest;
        this.target = target2;
        this.lifecycle = lifecycle;
        this.job = job2;
    }

    @MainThread
    public final void restart() {
        this.imageLoader.enqueue(this.initialRequest);
    }

    @Override
    public void assertActive() {
        if (!this.target.getView().isAttachedToWindow()) {
            -Utils.getRequestManager(this.target.getView()).setRequest(this);
            throw new CancellationException("'ViewTarget.view' must be attached to a window.");
        }
    }

    @Override
    public void start() {
        this.lifecycle.addObserver((LifecycleObserver)this);
        if (this.target instanceof LifecycleObserver) {
            -Lifecycles.removeAndAddObserver(this.lifecycle, (LifecycleObserver)this.target);
        }
        -Utils.getRequestManager(this.target.getView()).setRequest(this);
    }

    @Override
    public void dispose() {
        Job.DefaultImpls.cancel$default((Job)this.job, null, (int)1, null);
        if (this.target instanceof LifecycleObserver) {
            this.lifecycle.removeObserver((LifecycleObserver)this.target);
        }
        this.lifecycle.removeObserver((LifecycleObserver)this);
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        -Utils.getRequestManager(this.target.getView()).dispose();
    }
}

