/*
 * Decompiled with CFR 0.152.
 */
package coil.target;

import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import coil.target.ViewTarget;
import coil.transition.TransitionTarget;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0004J\u0012\u0010\u001a\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0004R\u001a\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcoil/target/GenericViewTarget;", "T", "Landroid/view/View;", "Lcoil/target/ViewTarget;", "Lcoil/transition/TransitionTarget;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "()V", "drawable", "Landroid/graphics/drawable/Drawable;", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "setDrawable", "(Landroid/graphics/drawable/Drawable;)V", "isStarted", "", "onError", "", "error", "onStart", "placeholder", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onStop", "onSuccess", "result", "updateAnimation", "updateDrawable", "coil-base_release"})
public abstract class GenericViewTarget<T extends View>
implements ViewTarget<T>,
TransitionTarget,
DefaultLifecycleObserver {
    private boolean isStarted;

    @Override
    @Nullable
    public abstract Drawable getDrawable();

    public abstract void setDrawable(@Nullable Drawable var1);

    @Override
    public void onStart(@Nullable Drawable placeholder) {
        this.updateDrawable(placeholder);
    }

    @Override
    public void onError(@Nullable Drawable error) {
        this.updateDrawable(error);
    }

    @Override
    public void onSuccess(@NotNull Drawable result2) {
        this.updateDrawable(result2);
    }

    public void onStart(@NotNull LifecycleOwner owner) {
        this.isStarted = true;
        this.updateAnimation();
    }

    public void onStop(@NotNull LifecycleOwner owner) {
        this.isStarted = false;
        this.updateAnimation();
    }

    protected final void updateDrawable(@Nullable Drawable drawable) {
        Drawable drawable2 = this.getDrawable();
        Animatable animatable = drawable2 instanceof Animatable ? (Animatable)drawable2 : null;
        if (animatable != null) {
            animatable.stop();
        }
        this.setDrawable(drawable);
        this.updateAnimation();
    }

    protected final void updateAnimation() {
        Drawable drawable = this.getDrawable();
        Animatable animatable = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable == null) {
            return;
        }
        Animatable animatable2 = animatable;
        if (this.isStarted) {
            animatable2.start();
        } else {
            animatable2.stop();
        }
    }
}

