/*
 * Decompiled with CFR 0.152.
 */
package coil.map;

import android.content.res.Resources;
import android.net.Uri;
import coil.map.Mapper;
import coil.request.Options;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcoil/map/ResourceUriMapper;", "Lcoil/map/Mapper;", "Landroid/net/Uri;", "()V", "isApplicable", "", "data", "map", "options", "Lcoil/request/Options;", "coil-base_release"})
@SourceDebugExtension(value={"SMAP\nResourceUriMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceUriMapper.kt\ncoil/map/ResourceUriMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,34:1\n1#2:35\n29#3:36\n*S KotlinDebug\n*F\n+ 1 ResourceUriMapper.kt\ncoil/map/ResourceUriMapper\n*L\n25#1:36\n*E\n"})
public final class ResourceUriMapper
implements Mapper<Uri, Uri> {
    @Override
    @Nullable
    public Uri map(@NotNull Uri data, @NotNull Options options) {
        if (!this.isApplicable(data)) {
            return null;
        }
        String string = data.getAuthority();
        if (string == null) {
            string = "";
        }
        String packageName = string;
        Resources resources = options.getContext().getPackageManager().getResourcesForApplication(packageName);
        List list = data.getPathSegments();
        String type = (String)list.get(0);
        String name = (String)list.get(1);
        int id2 = resources.getIdentifier(name, type, packageName);
        if (!(id2 != 0)) {
            boolean $i$a$-check-ResourceUriMapper$map$22 = false;
            String $i$a$-check-ResourceUriMapper$map$22 = "Invalid android.resource URI: " + data;
            throw new IllegalStateException($i$a$-check-ResourceUriMapper$map$22.toString());
        }
        String $this$toUri$iv = "android.resource://" + packageName + '/' + id2;
        boolean $i$f$toUri = false;
        Uri uri = Uri.parse((String)$this$toUri$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(this)");
        return uri;
    }

    private final boolean isApplicable(Uri data) {
        CharSequence charSequence;
        return Intrinsics.areEqual((Object)data.getScheme(), (Object)"android.resource") && !((charSequence = (CharSequence)data.getAuthority()) == null || StringsKt.isBlank((CharSequence)charSequence)) && ((Collection)data.getPathSegments()).size() == 2;
    }
}

