/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.VisibleForTesting;
import coil.ImageLoader;
import coil.decode.ContentMetadata;
import coil.decode.DataSource;
import coil.decode.ImageSource;
import coil.decode.ImageSources;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.SourceResult;
import coil.request.Options;
import coil.size.Dimension;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\b\fJ\u0015\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\b\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lcoil/fetch/ContentUriFetcher;", "Lcoil/fetch/Fetcher;", "data", "Landroid/net/Uri;", "options", "Lcoil/request/Options;", "(Landroid/net/Uri;Lcoil/request/Options;)V", "fetch", "Lcoil/fetch/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isContactPhotoUri", "", "isContactPhotoUri$coil_base_release", "isMusicThumbnailUri", "isMusicThumbnailUri$coil_base_release", "newMusicThumbnailSizeOptions", "Landroid/os/Bundle;", "Factory", "coil-base_release"})
@SourceDebugExtension(value={"SMAP\nContentUriFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentUriFetcher.kt\ncoil/fetch/ContentUriFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class ContentUriFetcher
implements Fetcher {
    @NotNull
    private final Uri data;
    @NotNull
    private final Options options;

    public ContentUriFetcher(@NotNull Uri data, @NotNull Options options) {
        this.data = data;
        this.options = options;
    }

    @Override
    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> $completion) {
        InputStream inputStream;
        InputStream stream;
        ContentResolver contentResolver = this.options.getContext().getContentResolver();
        if (this.isContactPhotoUri$coil_base_release(this.data)) {
            AssetFileDescriptor assetFileDescriptor = contentResolver.openAssetFileDescriptor(this.data, "r");
            InputStream inputStream2 = stream = assetFileDescriptor != null ? assetFileDescriptor.createInputStream() : null;
            if (inputStream2 == null) {
                boolean $i$a$-checkNotNull-ContentUriFetcher$fetch$inputStream$42 = false;
                String $i$a$-checkNotNull-ContentUriFetcher$fetch$inputStream$42 = "Unable to find a contact photo associated with '" + this.data + "'.";
                throw new IllegalStateException($i$a$-checkNotNull-ContentUriFetcher$fetch$inputStream$42.toString());
            }
            inputStream = inputStream2;
        } else if (Build.VERSION.SDK_INT >= 29 && this.isMusicThumbnailUri$coil_base_release(this.data)) {
            FileInputStream stream2;
            Bundle bundle = this.newMusicThumbnailSizeOptions();
            AssetFileDescriptor assetFileDescriptor = contentResolver.openTypedAssetFile(this.data, "image/*", bundle, null);
            FileInputStream fileInputStream = stream2 = assetFileDescriptor != null ? assetFileDescriptor.createInputStream() : null;
            if (fileInputStream == null) {
                boolean bl = false;
                String string = "Unable to find a music thumbnail associated with '" + this.data + "'.";
                throw new IllegalStateException(string.toString());
            }
            inputStream = fileInputStream;
        } else {
            stream = contentResolver.openInputStream(this.data);
            inputStream = stream;
            if (inputStream == null) {
                boolean bl = false;
                String string = "Unable to open '" + this.data + "'.";
                throw new IllegalStateException(string.toString());
            }
        }
        InputStream inputStream3 = inputStream;
        return new SourceResult(ImageSources.create(Okio.buffer((Source)Okio.source((InputStream)inputStream3)), this.options.getContext(), (ImageSource.Metadata)new ContentMetadata(this.data)), contentResolver.getType(this.data), DataSource.DISK);
    }

    @VisibleForTesting
    public final boolean isContactPhotoUri$coil_base_release(@NotNull Uri data) {
        return Intrinsics.areEqual((Object)data.getAuthority(), (Object)"com.android.contacts") && Intrinsics.areEqual((Object)data.getLastPathSegment(), (Object)"display_photo");
    }

    @VisibleForTesting
    public final boolean isMusicThumbnailUri$coil_base_release(@NotNull Uri data) {
        if (!Intrinsics.areEqual((Object)data.getAuthority(), (Object)"media")) {
            return false;
        }
        List segments = data.getPathSegments();
        int size2 = segments.size();
        return size2 >= 3 && Intrinsics.areEqual(segments.get(size2 - 3), (Object)"audio") && Intrinsics.areEqual(segments.get(size2 - 2), (Object)"albums");
    }

    private final Bundle newMusicThumbnailSizeOptions() {
        Dimension dimension = this.options.getSize().getWidth();
        Dimension.Pixels pixels = dimension instanceof Dimension.Pixels ? (Dimension.Pixels)dimension : null;
        if (pixels == null) {
            return null;
        }
        int width = pixels.px;
        Dimension dimension2 = this.options.getSize().getHeight();
        Dimension.Pixels pixels2 = dimension2 instanceof Dimension.Pixels ? (Dimension.Pixels)dimension2 : null;
        if (pixels2 == null) {
            return null;
        }
        int height = pixels2.px;
        Dimension $this$newMusicThumbnailSizeOptions_u24lambda_u243 = dimension = new Bundle(1);
        boolean bl = false;
        $this$newMusicThumbnailSizeOptions_u24lambda_u243.putParcelable("android.content.extra.SIZE", (Parcelable)new Point(width, height));
        return dimension;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lcoil/fetch/ContentUriFetcher$Factory;", "Lcoil/fetch/Fetcher$Factory;", "Landroid/net/Uri;", "()V", "create", "Lcoil/fetch/Fetcher;", "data", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "isApplicable", "", "coil-base_release"})
    public static final class Factory
    implements Fetcher.Factory<Uri> {
        @Override
        @Nullable
        public Fetcher create(@NotNull Uri data, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!this.isApplicable(data)) {
                return null;
            }
            return new ContentUriFetcher(data, options);
        }

        private final boolean isApplicable(Uri data) {
            return Intrinsics.areEqual((Object)data.getScheme(), (Object)"content");
        }
    }
}

