/*
 * Decompiled with CFR 0.152.
 */
package coil;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import androidx.annotation.MainThread;
import coil.ComponentRegistry;
import coil.EventListener;
import coil.ImageLoader;
import coil.RealImageLoader;
import coil.decode.BitmapFactoryDecoder;
import coil.decode.DataSource;
import coil.disk.DiskCache;
import coil.fetch.AssetUriFetcher;
import coil.fetch.BitmapFetcher;
import coil.fetch.ByteBufferFetcher;
import coil.fetch.ContentUriFetcher;
import coil.fetch.DrawableFetcher;
import coil.fetch.Fetcher;
import coil.fetch.FileFetcher;
import coil.fetch.HttpUriFetcher;
import coil.fetch.ResourceUriFetcher;
import coil.intercept.EngineInterceptor;
import coil.intercept.Interceptor;
import coil.intercept.RealInterceptorChain;
import coil.key.FileKeyer;
import coil.key.Keyer;
import coil.key.UriKeyer;
import coil.map.ByteArrayMapper;
import coil.map.FileUriMapper;
import coil.map.HttpUrlMapper;
import coil.map.Mapper;
import coil.map.ResourceIntMapper;
import coil.map.ResourceUriMapper;
import coil.map.StringMapper;
import coil.memory.MemoryCache;
import coil.request.DefaultRequestOptions;
import coil.request.Disposable;
import coil.request.ErrorResult;
import coil.request.ImageRequest;
import coil.request.ImageResult;
import coil.request.NullRequestData;
import coil.request.NullRequestDataException;
import coil.request.OneShotDisposable;
import coil.request.RequestDelegate;
import coil.request.RequestService;
import coil.request.SuccessResult;
import coil.size.Size;
import coil.target.Target;
import coil.target.ViewTarget;
import coil.transition.NoneTransition;
import coil.transition.Transition;
import coil.transition.TransitionTarget;
import coil.util.-Lifecycles;
import coil.util.-Logs;
import coil.util.-Utils;
import coil.util.ImageLoaderOptions;
import coil.util.Logger;
import coil.util.SystemCallbacks;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import okhttp3.Call;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 [2\u00020\u0001:\u0001[Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u0016\u0010@\u001a\u00020A2\u0006\u0010>\u001a\u00020?H\u0096@\u00a2\u0006\u0002\u0010BJ\u001e\u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020?2\u0006\u0010E\u001a\u00020FH\u0083@\u00a2\u0006\u0002\u0010GJ\b\u0010H\u001a\u00020IH\u0016J\u0018\u0010J\u001a\u00020K2\u0006\u0010>\u001a\u00020?2\u0006\u0010L\u001a\u00020MH\u0002J\"\u0010N\u001a\u00020K2\u0006\u0010O\u001a\u00020P2\b\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010L\u001a\u00020MH\u0002J\"\u0010S\u001a\u00020K2\u0006\u0010O\u001a\u00020T2\b\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010L\u001a\u00020MH\u0002J\u0015\u0010U\u001a\u00020K2\u0006\u0010V\u001a\u00020FH\u0000\u00a2\u0006\u0002\bWJ\b\u00108\u001a\u00020KH\u0016J1\u0010X\u001a\u00020K2\u0006\u0010O\u001a\u00020A2\b\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010L\u001a\u00020M2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020K0ZH\u0082\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001d\u0010 \u001a\u0004\u0018\u00010\n8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b#\u0010$*\u0004\b!\u0010\"R\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0017R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001d\u0010-\u001a\u0004\u0018\u00010\b8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b/\u00100*\u0004\b.\u0010\"R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0017R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lcoil/RealImageLoader;", "Lcoil/ImageLoader;", "context", "Landroid/content/Context;", "defaults", "Lcoil/request/DefaultRequestOptions;", "memoryCacheLazy", "Lkotlin/Lazy;", "Lcoil/memory/MemoryCache;", "diskCacheLazy", "Lcoil/disk/DiskCache;", "callFactoryLazy", "Lokhttp3/Call$Factory;", "eventListenerFactory", "Lcoil/EventListener$Factory;", "componentRegistry", "Lcoil/ComponentRegistry;", "options", "Lcoil/util/ImageLoaderOptions;", "logger", "Lcoil/util/Logger;", "(Landroid/content/Context;Lcoil/request/DefaultRequestOptions;Lkotlin/Lazy;Lkotlin/Lazy;Lkotlin/Lazy;Lcoil/EventListener$Factory;Lcoil/ComponentRegistry;Lcoil/util/ImageLoaderOptions;Lcoil/util/Logger;)V", "getCallFactoryLazy", "()Lkotlin/Lazy;", "getComponentRegistry", "()Lcoil/ComponentRegistry;", "components", "getComponents", "getContext", "()Landroid/content/Context;", "getDefaults", "()Lcoil/request/DefaultRequestOptions;", "diskCache", "getDiskCache$delegate", "(Lcoil/RealImageLoader;)Ljava/lang/Object;", "getDiskCache", "()Lcoil/disk/DiskCache;", "getDiskCacheLazy", "getEventListenerFactory", "()Lcoil/EventListener$Factory;", "interceptors", "", "Lcoil/intercept/Interceptor;", "getLogger", "()Lcoil/util/Logger;", "memoryCache", "getMemoryCache$delegate", "getMemoryCache", "()Lcoil/memory/MemoryCache;", "getMemoryCacheLazy", "getOptions", "()Lcoil/util/ImageLoaderOptions;", "requestService", "Lcoil/request/RequestService;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "shutdown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "systemCallbacks", "Lcoil/util/SystemCallbacks;", "enqueue", "Lcoil/request/Disposable;", "request", "Lcoil/request/ImageRequest;", "execute", "Lcoil/request/ImageResult;", "(Lcoil/request/ImageRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeMain", "initialRequest", "type", "", "(Lcoil/request/ImageRequest;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "newBuilder", "Lcoil/ImageLoader$Builder;", "onCancel", "", "eventListener", "Lcoil/EventListener;", "onError", "result", "Lcoil/request/ErrorResult;", "target", "Lcoil/target/Target;", "onSuccess", "Lcoil/request/SuccessResult;", "onTrimMemory", "level", "onTrimMemory$coil_base_release", "transition", "setDrawable", "Lkotlin/Function0;", "Companion", "coil-base_release"})
@SourceDebugExtension(value={"SMAP\nRealImageLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealImageLoader.kt\ncoil/RealImageLoader\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n+ 3 ComponentRegistry.kt\ncoil/ComponentRegistry$Builder\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Utils.kt\ncoil/util/-Utils\n+ 6 Bitmaps.kt\ncoil/util/-Bitmaps\n+ 7 BitmapDrawable.kt\nandroidx/core/graphics/drawable/BitmapDrawableKt\n+ 8 Logs.kt\ncoil/util/-Logs\n*L\n1#1,292:1\n270#1,15:322\n270#1,15:341\n48#2,4:293\n138#3:297\n138#3:298\n138#3:299\n138#3:300\n138#3:301\n138#3:302\n146#3:303\n146#3:304\n154#3:305\n154#3:306\n154#3:307\n154#3:308\n154#3:309\n154#3:310\n154#3:311\n154#3:312\n1#4:313\n1#4:315\n173#5:314\n50#6:316\n28#7:317\n21#8,4:318\n21#8,4:337\n21#8,4:356\n*S KotlinDebug\n*F\n+ 1 RealImageLoader.kt\ncoil/RealImageLoader\n*L\n237#1:322,15\n251#1:341,15\n78#1:293,4\n85#1:297\n86#1:298\n87#1:299\n88#1:300\n89#1:301\n90#1:302\n92#1:303\n93#1:304\n95#1:305\n96#1:306\n97#1:307\n98#1:308\n99#1:309\n100#1:310\n101#1:311\n102#1:312\n166#1:315\n166#1:314\n167#1:316\n167#1:317\n234#1:318,4\n248#1:337,4\n257#1:356,4\n*E\n"})
public final class RealImageLoader
implements ImageLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final DefaultRequestOptions defaults;
    @NotNull
    private final Lazy<MemoryCache> memoryCacheLazy;
    @NotNull
    private final Lazy<DiskCache> diskCacheLazy;
    @NotNull
    private final Lazy<Call.Factory> callFactoryLazy;
    @NotNull
    private final EventListener.Factory eventListenerFactory;
    @NotNull
    private final ComponentRegistry componentRegistry;
    @NotNull
    private final ImageLoaderOptions options;
    @Nullable
    private final Logger logger;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final SystemCallbacks systemCallbacks;
    @NotNull
    private final RequestService requestService;
    @NotNull
    private final ComponentRegistry components;
    @NotNull
    private final List<Interceptor> interceptors;
    @NotNull
    private final AtomicBoolean shutdown;
    @NotNull
    private static final String TAG = "RealImageLoader";
    private static final int REQUEST_TYPE_ENQUEUE = 0;
    private static final int REQUEST_TYPE_EXECUTE = 1;

    public RealImageLoader(@NotNull Context context, @NotNull DefaultRequestOptions defaults, @NotNull Lazy<? extends MemoryCache> memoryCacheLazy, @NotNull Lazy<? extends DiskCache> diskCacheLazy, @NotNull Lazy<? extends Call.Factory> callFactoryLazy, @NotNull EventListener.Factory eventListenerFactory, @NotNull ComponentRegistry componentRegistry, @NotNull ImageLoaderOptions options, @Nullable Logger logger) {
        ComponentRegistry.Builder this_$iv;
        this.context = context;
        this.defaults = defaults;
        this.memoryCacheLazy = memoryCacheLazy;
        this.diskCacheLazy = diskCacheLazy;
        this.callFactoryLazy = callFactoryLazy;
        this.eventListenerFactory = eventListenerFactory;
        this.componentRegistry = componentRegistry;
        this.options = options;
        this.logger = logger;
        boolean $i$f$CoroutineExceptionHandler22 = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getMain().getImmediate()).plus((CoroutineContext)new CoroutineExceptionHandler(key, this){
            final /* synthetic */ RealImageLoader this$0;
            {
                this.this$0 = realImageLoader;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                block0: {
                    Throwable throwable = exception;
                    boolean bl = false;
                    Logger logger = this.this$0.getLogger();
                    if (logger == null) break block0;
                    -Logs.log(logger, "RealImageLoader", throwable);
                }
            }
        }));
        this.systemCallbacks = new SystemCallbacks(this);
        this.requestService = new RequestService(this, this.systemCallbacks, this.logger);
        ComponentRegistry.Builder $i$f$CoroutineExceptionHandler22 = this.componentRegistry.newBuilder();
        Mapper mapper$iv = new HttpUrlMapper();
        boolean $i$f$add = false;
        this_$iv = this_$iv.add(mapper$iv, HttpUrl.class);
        mapper$iv = new StringMapper();
        $i$f$add = false;
        this_$iv = this_$iv.add(mapper$iv, String.class);
        mapper$iv = new FileUriMapper();
        $i$f$add = false;
        this_$iv = this_$iv.add(mapper$iv, Uri.class);
        mapper$iv = new ResourceUriMapper();
        $i$f$add = false;
        this_$iv = this_$iv.add(mapper$iv, Uri.class);
        mapper$iv = new ResourceIntMapper();
        $i$f$add = false;
        this_$iv = this_$iv.add(mapper$iv, Integer.class);
        mapper$iv = new ByteArrayMapper();
        $i$f$add = false;
        this_$iv = this_$iv.add(mapper$iv, byte[].class);
        Keyer keyer$iv = new UriKeyer();
        $i$f$add = false;
        this_$iv = this_$iv.add(keyer$iv, Uri.class);
        keyer$iv = new FileKeyer(this.options.getAddLastModifiedToFileCacheKey());
        $i$f$add = false;
        this_$iv = this_$iv.add(keyer$iv, File.class);
        Fetcher.Factory factory$iv = new HttpUriFetcher.Factory(this.callFactoryLazy, this.diskCacheLazy, this.options.getRespectCacheHeaders());
        $i$f$add = false;
        this_$iv = this_$iv.add(factory$iv, Uri.class);
        factory$iv = new FileFetcher.Factory();
        $i$f$add = false;
        this_$iv = this_$iv.add(factory$iv, File.class);
        factory$iv = new AssetUriFetcher.Factory();
        $i$f$add = false;
        this_$iv = this_$iv.add(factory$iv, Uri.class);
        factory$iv = new ContentUriFetcher.Factory();
        $i$f$add = false;
        this_$iv = this_$iv.add(factory$iv, Uri.class);
        factory$iv = new ResourceUriFetcher.Factory();
        $i$f$add = false;
        this_$iv = this_$iv.add(factory$iv, Uri.class);
        factory$iv = new DrawableFetcher.Factory();
        $i$f$add = false;
        this_$iv = this_$iv.add(factory$iv, Drawable.class);
        factory$iv = new BitmapFetcher.Factory();
        $i$f$add = false;
        this_$iv = this_$iv.add(factory$iv, Bitmap.class);
        factory$iv = new ByteBufferFetcher.Factory();
        $i$f$add = false;
        this.components = this_$iv.add(factory$iv, ByteBuffer.class).add(new BitmapFactoryDecoder.Factory(this.options.getBitmapFactoryMaxParallelism(), this.options.getBitmapFactoryExifOrientationPolicy())).build();
        this.interceptors = CollectionsKt.plus((Collection)this.getComponents().getInterceptors(), (Object)new EngineInterceptor(this, this.systemCallbacks, this.requestService, this.logger));
        this.shutdown = new AtomicBoolean(false);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public DefaultRequestOptions getDefaults() {
        return this.defaults;
    }

    @NotNull
    public final Lazy<MemoryCache> getMemoryCacheLazy() {
        return this.memoryCacheLazy;
    }

    @NotNull
    public final Lazy<DiskCache> getDiskCacheLazy() {
        return this.diskCacheLazy;
    }

    @NotNull
    public final Lazy<Call.Factory> getCallFactoryLazy() {
        return this.callFactoryLazy;
    }

    @NotNull
    public final EventListener.Factory getEventListenerFactory() {
        return this.eventListenerFactory;
    }

    @NotNull
    public final ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    @NotNull
    public final ImageLoaderOptions getOptions() {
        return this.options;
    }

    @Nullable
    public final Logger getLogger() {
        return this.logger;
    }

    @Override
    @Nullable
    public MemoryCache getMemoryCache() {
        Lazy<MemoryCache> lazy = this.memoryCacheLazy;
        return (MemoryCache)lazy.getValue();
    }

    private static Object getMemoryCache$delegate(RealImageLoader realImageLoader) {
        return realImageLoader.memoryCacheLazy;
    }

    @Override
    @Nullable
    public DiskCache getDiskCache() {
        Lazy<DiskCache> lazy = this.diskCacheLazy;
        return (DiskCache)lazy.getValue();
    }

    private static Object getDiskCache$delegate(RealImageLoader realImageLoader) {
        return realImageLoader.diskCacheLazy;
    }

    @Override
    @NotNull
    public ComponentRegistry getComponents() {
        return this.components;
    }

    @Override
    @NotNull
    public Disposable enqueue(@NotNull ImageRequest request) {
        Deferred job2 = BuildersKt.async$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ImageResult>, Object>(this, request, null){
            int label;
            final /* synthetic */ RealImageLoader this$0;
            final /* synthetic */ ImageRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = RealImageLoader.access$executeMain(this.this$0, this.$request, 0, (Continuation)this);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = v0;
                        var3_4 = this.this$0;
                        result = (ImageResult)var2_3;
                        $i$a$-also-RealImageLoader$enqueue$job$1$1 = false;
                        if (result instanceof ErrorResult) {
                            v1 = var3_4.getLogger();
                            if (v1 != null) {
                                -Logs.log(v1, "RealImageLoader", ((ErrorResult)result).getThrowable());
                            }
                        }
                        return var2_3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ImageResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return request.getTarget() instanceof ViewTarget ? (Disposable)-Utils.getRequestManager(((ViewTarget)request.getTarget()).getView()).getDisposable((Deferred<? extends ImageResult>)job2) : (Disposable)new OneShotDisposable((Deferred<? extends ImageResult>)job2);
    }

    @Override
    @Nullable
    public Object execute(@NotNull ImageRequest request, @NotNull Continuation<? super ImageResult> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ImageResult>, Object>(request, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ImageRequest $request;
            final /* synthetic */ RealImageLoader this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                        Deferred job2 = BuildersKt.async$default((CoroutineScope)$this$coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain().getImmediate()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ImageResult>, Object>(this.this$0, this.$request, null){
                            int label;
                            final /* synthetic */ RealImageLoader this$0;
                            final /* synthetic */ ImageRequest $request;
                            {
                                this.this$0 = $receiver;
                                this.$request = $request;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = RealImageLoader.access$executeMain(this.this$0, this.$request, 1, (Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ImageResult> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        if (this.$request.getTarget() instanceof ViewTarget) {
                            -Utils.getRequestManager(((ViewTarget)this.$request.getTarget()).getView()).getDisposable((Deferred<? extends ImageResult>)job2);
                        }
                        this.label = 1;
                        Object object3 = job2.await((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super ImageResult>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ImageResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @MainThread
    private final Object executeMain(ImageRequest var1_1, int var2_2, Continuation<? super ImageResult> var3_3) {
        if (!(var3_3 instanceof executeMain.1)) ** GOTO lbl-1000
        var17_4 = var3_3;
        if ((var17_4.label & -2147483648) != 0) {
            var17_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ RealImageLoader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RealImageLoader.access$executeMain(this.this$0, null, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$executeMain_u24lambda_u241 = var5_7 = this.requestService.requestDelegate((ImageRequest)initialRequest, JobKt.getJob((CoroutineContext)$continuation.getContext()));
                $i$a$-apply-RealImageLoader$executeMain$requestDelegate$1 = false;
                $this$executeMain_u24lambda_u241.assertActive();
                requestDelegate = var5_7;
                request = ImageRequest.newBuilder$default((ImageRequest)initialRequest, null, 1, null).defaults(this.getDefaults()).build();
                eventListener = this.eventListenerFactory.create(request);
                if (request.getData() == NullRequestData.INSTANCE) {
                    throw new NullRequestDataException();
                }
                requestDelegate.start();
                if (type != false) ** GOTO lbl42
                $continuation.L$0 = this;
                $continuation.L$1 = requestDelegate;
                $continuation.L$2 = request;
                $continuation.L$3 = eventListener;
                $continuation.label = 1;
                v0 = -Lifecycles.awaitStarted(request.getLifecycle(), (Continuation<? super Unit>)$continuation);
                ** if (v0 != var18_6) goto lbl32
lbl31:
                // 1 sources

                return var18_6;
lbl32:
                // 1 sources

                ** GOTO lbl42
            }
            case 1: {
                eventListener = (EventListener)$continuation.L$3;
                request = (ImageRequest)$continuation.L$2;
                requestDelegate = (RequestDelegate)$continuation.L$1;
                this = (RealImageLoader)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl42:
                // 3 sources

                if ((v1 = this.getMemoryCache()) == null) ** GOTO lbl-1000
                var10_14 = v1;
                key$iv = request.getPlaceholderMemoryCacheKey();
                $i$f$get = false;
                v2 = key$iv;
                if (v2 != null) {
                    p0$iv = v2;
                    $i$a$-let--Utils$get$1$iv = false;
                    v3 = $this$get$iv.get(p0$iv);
                } else {
                    v3 = v1 = null;
                }
                if (v3 != null) {
                    v4 = v1.getBitmap();
                } else lbl-1000:
                // 2 sources

                {
                    v4 = null;
                }
                v5 = placeholderBitmap = v4;
                if (v5 != null) {
                    $this$get$iv = v5;
                    context$iv = request.getContext();
                    $i$f$toDrawable = false;
                    p0$iv = $this$toDrawable$iv;
                    resources$iv$iv = context$iv.getResources();
                    $i$f$toDrawable = false;
                    v6 = (Drawable)new BitmapDrawable(resources$iv$iv, (Bitmap)$this$toDrawable$iv$iv);
                } else {
                    v6 = request.getPlaceholder();
                }
                placeholder = v6;
                v7 = request.getTarget();
                if (v7 != null) {
                    v7.onStart(placeholder);
                }
                eventListener.onStart(request);
                v8 = request.getListener();
                if (v8 != null) {
                    v8.onStart(request);
                }
                eventListener.resolveSizeStart(request);
                $continuation.L$0 = this;
                $continuation.L$1 = requestDelegate;
                $continuation.L$2 = request;
                $continuation.L$3 = eventListener;
                $continuation.L$4 = placeholderBitmap;
                $continuation.label = 2;
                v9 = request.getSizeResolver().size((Continuation<? super Size>)$continuation);
                ** if (v9 != var18_6) goto lbl87
lbl86:
                // 1 sources

                return var18_6;
lbl87:
                // 1 sources

                ** GOTO lbl98
            }
            case 2: {
                placeholderBitmap = (Bitmap)$continuation.L$4;
                eventListener = (EventListener)$continuation.L$3;
                request = (ImageRequest)$continuation.L$2;
                requestDelegate = (RequestDelegate)$continuation.L$1;
                this = (RealImageLoader)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v9 = $result;
lbl98:
                // 2 sources

                size = (Size)v9;
                eventListener.resolveSizeEnd(request, size);
                $continuation.L$0 = this;
                $continuation.L$1 = requestDelegate;
                $continuation.L$2 = request;
                $continuation.L$3 = eventListener;
                $continuation.L$4 = null;
                $continuation.label = 3;
                v10 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)request.getInterceptorDispatcher()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ImageResult>, Object>(request, this, size, eventListener, placeholderBitmap, null){
                    int label;
                    final /* synthetic */ ImageRequest $request;
                    final /* synthetic */ RealImageLoader this$0;
                    final /* synthetic */ Size $size;
                    final /* synthetic */ EventListener $eventListener;
                    final /* synthetic */ Bitmap $placeholderBitmap;
                    {
                        this.$request = $request;
                        this.this$0 = $receiver;
                        this.$size = $size;
                        this.$eventListener = $eventListener;
                        this.$placeholderBitmap = $placeholderBitmap;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = new RealInterceptorChain(this.$request, RealImageLoader.access$getInterceptors$p(this.this$0), 0, this.$request, this.$size, this.$eventListener, this.$placeholderBitmap != null).proceed(this.$request, (Continuation<? super ImageResult>)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ImageResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v10 != var18_6) goto lbl109
lbl108:
                // 1 sources

                return var18_6;
lbl109:
                // 1 sources

                ** GOTO lbl119
            }
            case 3: {
                eventListener = (EventListener)$continuation.L$3;
                request = (ImageRequest)$continuation.L$2;
                requestDelegate = (RequestDelegate)$continuation.L$1;
                this = (RealImageLoader)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v10 = $result;
lbl119:
                    // 2 sources

                    if ((var11_15 = (result = (ImageResult)v10)) instanceof SuccessResult) {
                        this.onSuccess((SuccessResult)result, request.getTarget(), eventListener);
                    } else if (var11_15 instanceof ErrorResult) {
                        this.onError((ErrorResult)result, request.getTarget(), eventListener);
                    }
                    var11_15 = result;
                    return var11_15;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof CancellationException) {
                        this.onCancel(request, eventListener);
                        throw throwable;
                    }
                    result = this.requestService.errorResult(request, throwable);
                    this.onError(result, request.getTarget(), eventListener);
                    var9_24 = result;
                    return var9_24;
                }
            }
            catch (Throwable var7_12) {
                throw var7_12;
            }
            {
                finally {
                    requestDelegate.complete();
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void onTrimMemory$coil_base_release(int level) {
        block0: {
            Object object = this.memoryCacheLazy;
            if (object == null || (object = (MemoryCache)object.getValue()) == null) break block0;
            object.trimMemory(level);
        }
    }

    @Override
    public void shutdown() {
        block1: {
            if (this.shutdown.getAndSet(true)) {
                return;
            }
            CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
            this.systemCallbacks.shutdown();
            MemoryCache memoryCache = this.getMemoryCache();
            if (memoryCache == null) break block1;
            memoryCache.clear();
        }
    }

    @Override
    @NotNull
    public ImageLoader.Builder newBuilder() {
        return new ImageLoader.Builder(this);
    }

    /*
     * WARNING - void declaration
     */
    private final void onSuccess(SuccessResult result2, Target target2, EventListener eventListener) {
        block7: {
            ImageRequest request = result2.getRequest();
            DataSource dataSource = result2.getDataSource();
            Logger logger = this.logger;
            if (logger != null) {
                void $this$log$iv;
                Logger logger2 = logger;
                String string = TAG;
                int priority$iv = 4;
                boolean $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv) {
                    void tag$iv;
                    int n = priority$iv;
                    void var13_15 = tag$iv;
                    void var12_16 = $this$log$iv;
                    boolean bl = false;
                    String string2 = -Utils.getEmoji(dataSource) + " Successful (" + dataSource.name() + ") - " + request.getData();
                    var12_16.log((String)var13_15, n, string2, null);
                }
            }
            RealImageLoader this_$iv = this;
            boolean $i$f$transition = false;
            if (!(target2 instanceof TransitionTarget)) {
                boolean bl = false;
                Target target3 = target2;
                if (target3 != null) {
                    target3.onSuccess(result2.getDrawable());
                }
            } else {
                Transition transition$iv = ((ImageResult)result2).getRequest().getTransitionFactory().create((TransitionTarget)target2, result2);
                if (transition$iv instanceof NoneTransition) {
                    boolean bl = false;
                    target2.onSuccess(result2.getDrawable());
                } else {
                    eventListener.transitionStart(((ImageResult)result2).getRequest(), transition$iv);
                    transition$iv.transition();
                    eventListener.transitionEnd(((ImageResult)result2).getRequest(), transition$iv);
                }
            }
            eventListener.onSuccess(request, result2);
            ImageRequest.Listener listener2 = request.getListener();
            if (listener2 == null) break block7;
            listener2.onSuccess(request, result2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onError(ErrorResult result2, Target target2, EventListener eventListener) {
        block7: {
            ImageRequest request = result2.getRequest();
            Logger logger = this.logger;
            if (logger != null) {
                void $this$log$iv;
                Logger logger2 = logger;
                String string = TAG;
                int priority$iv = 4;
                boolean $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv) {
                    void tag$iv;
                    int n = priority$iv;
                    void var12_14 = tag$iv;
                    void var11_15 = $this$log$iv;
                    boolean bl = false;
                    String string2 = "\ud83d\udea8 Failed - " + request.getData() + " - " + result2.getThrowable();
                    var11_15.log((String)var12_14, n, string2, null);
                }
            }
            RealImageLoader this_$iv = this;
            boolean $i$f$transition = false;
            if (!(target2 instanceof TransitionTarget)) {
                boolean bl = false;
                Target target3 = target2;
                if (target3 != null) {
                    target3.onError(result2.getDrawable());
                }
            } else {
                Transition transition$iv = ((ImageResult)result2).getRequest().getTransitionFactory().create((TransitionTarget)target2, result2);
                if (transition$iv instanceof NoneTransition) {
                    boolean bl = false;
                    target2.onError(result2.getDrawable());
                } else {
                    eventListener.transitionStart(((ImageResult)result2).getRequest(), transition$iv);
                    transition$iv.transition();
                    eventListener.transitionEnd(((ImageResult)result2).getRequest(), transition$iv);
                }
            }
            eventListener.onError(request, result2);
            ImageRequest.Listener listener2 = request.getListener();
            if (listener2 == null) break block7;
            listener2.onError(request, result2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onCancel(ImageRequest request, EventListener eventListener) {
        block2: {
            Logger logger = this.logger;
            if (logger != null) {
                void $this$log$iv;
                Logger logger2 = logger;
                String string = TAG;
                int priority$iv = 4;
                boolean $i$f$log = false;
                if ($this$log$iv.getLevel() <= priority$iv) {
                    void tag$iv;
                    int n = priority$iv;
                    void var9_8 = tag$iv;
                    void var8_9 = $this$log$iv;
                    boolean bl = false;
                    String string2 = "\ud83c\udfd7  Cancelled - " + request.getData();
                    var8_9.log((String)var9_8, n, string2, null);
                }
            }
            eventListener.onCancel(request);
            ImageRequest.Listener listener2 = request.getListener();
            if (listener2 == null) break block2;
            listener2.onCancel(request);
        }
    }

    private final void transition(ImageResult result2, Target target2, EventListener eventListener, Function0<Unit> setDrawable) {
        boolean $i$f$transition = false;
        if (!(target2 instanceof TransitionTarget)) {
            setDrawable.invoke();
            return;
        }
        Transition transition = result2.getRequest().getTransitionFactory().create((TransitionTarget)target2, result2);
        if (transition instanceof NoneTransition) {
            setDrawable.invoke();
            return;
        }
        eventListener.transitionStart(result2.getRequest(), transition);
        transition.transition();
        eventListener.transitionEnd(result2.getRequest(), transition);
    }

    public static final /* synthetic */ Object access$executeMain(RealImageLoader $this, ImageRequest initialRequest, int type, Continuation $completion) {
        return $this.executeMain(initialRequest, type, (Continuation<? super ImageResult>)$completion);
    }

    public static final /* synthetic */ List access$getInterceptors$p(RealImageLoader $this) {
        return $this.interceptors;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcoil/RealImageLoader$Companion;", "", "()V", "REQUEST_TYPE_ENQUEUE", "", "REQUEST_TYPE_EXECUTE", "TAG", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

