/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.FloatRange;
import coil.memory.EmptyStrongMemoryCache;
import coil.memory.EmptyWeakMemoryCache;
import coil.memory.RealMemoryCache;
import coil.memory.RealStrongMemoryCache;
import coil.memory.RealWeakMemoryCache;
import coil.memory.StrongMemoryCache;
import coil.memory.WeakMemoryCache;
import coil.util.-Utils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001:\u0003\u0018\u0019\u001aJ\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u00a6\u0002J\u0019\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000eH\u00a6\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\nH&J\b\u0010\u0015\u001a\u00020\u0011H&J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lcoil/memory/MemoryCache;", "", "size", "", "getSize", "()I", "maxSize", "getMaxSize", "keys", "", "Lcoil/memory/MemoryCache$Key;", "getKeys", "()Ljava/util/Set;", "get", "Lcoil/memory/MemoryCache$Value;", "key", "set", "", "value", "remove", "", "clear", "trimMemory", "level", "Key", "Value", "Builder", "coil-base_release"})
public interface MemoryCache {
    public int getSize();

    public int getMaxSize();

    @NotNull
    public Set<Key> getKeys();

    @Nullable
    public Value get(@NotNull Key var1);

    public void set(@NotNull Key var1, @NotNull Value var2);

    public boolean remove(@NotNull Key var1);

    public void clear();

    public void trimMemory(int var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00002\b\b\u0001\u0010\r\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcoil/memory/MemoryCache$Builder;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "maxSizePercent", "", "maxSizeBytes", "", "strongReferencesEnabled", "", "weakReferencesEnabled", "percent", "size", "enable", "build", "Lcoil/memory/MemoryCache;", "coil-base_release"})
    @SourceDebugExtension(value={"SMAP\nMemoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCache.kt\ncoil/memory/MemoryCache$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1#2:217\n*E\n"})
    public static final class Builder {
        @NotNull
        private final Context context;
        private double maxSizePercent;
        private int maxSizeBytes;
        private boolean strongReferencesEnabled;
        private boolean weakReferencesEnabled;

        public Builder(@NotNull Context context) {
            this.context = context;
            this.maxSizePercent = -Utils.defaultMemoryCacheSizePercent(this.context);
            this.strongReferencesEnabled = true;
            this.weakReferencesEnabled = true;
        }

        @NotNull
        public final Builder maxSizePercent(@FloatRange(from=0.0, to=1.0) double percent) {
            Builder builder;
            Builder $this$maxSizePercent_u24lambda_u241 = builder = this;
            boolean bl = false;
            if (!(0.0 <= percent ? percent <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "size must be in the range [0.0, 1.0].";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maxSizePercent_u24lambda_u241.maxSizeBytes = 0;
            $this$maxSizePercent_u24lambda_u241.maxSizePercent = percent;
            return builder;
        }

        @NotNull
        public final Builder maxSizeBytes(int size2) {
            Builder builder;
            Builder $this$maxSizeBytes_u24lambda_u243 = builder = this;
            boolean bl = false;
            if (!(size2 >= 0)) {
                boolean bl2 = false;
                String string = "size must be >= 0.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maxSizeBytes_u24lambda_u243.maxSizePercent = 0.0;
            $this$maxSizeBytes_u24lambda_u243.maxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder strongReferencesEnabled(boolean enable) {
            Builder builder;
            Builder $this$strongReferencesEnabled_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$strongReferencesEnabled_u24lambda_u244.strongReferencesEnabled = enable;
            return builder;
        }

        @NotNull
        public final Builder weakReferencesEnabled(boolean enable) {
            Builder builder;
            Builder $this$weakReferencesEnabled_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$weakReferencesEnabled_u24lambda_u245.weakReferencesEnabled = enable;
            return builder;
        }

        @NotNull
        public final MemoryCache build() {
            StrongMemoryCache strongMemoryCache;
            WeakMemoryCache weakMemoryCache;
            WeakMemoryCache weakMemoryCache2 = weakMemoryCache = this.weakReferencesEnabled ? (WeakMemoryCache)new RealWeakMemoryCache() : (WeakMemoryCache)new EmptyWeakMemoryCache();
            if (this.strongReferencesEnabled) {
                int maxSize;
                int n = maxSize = this.maxSizePercent > 0.0 ? -Utils.calculateMemoryCacheSize(this.context, this.maxSizePercent) : this.maxSizeBytes;
                strongMemoryCache = maxSize > 0 ? (StrongMemoryCache)new RealStrongMemoryCache(maxSize, weakMemoryCache) : (StrongMemoryCache)new EmptyStrongMemoryCache(weakMemoryCache);
            } else {
                strongMemoryCache = new EmptyStrongMemoryCache(weakMemoryCache);
            }
            StrongMemoryCache strongMemoryCache2 = strongMemoryCache;
            return new RealMemoryCache(strongMemoryCache2, weakMemoryCache);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcoil/memory/MemoryCache$Key;", "Landroid/os/Parcelable;", "key", "", "extras", "", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "getKey", "()Ljava/lang/String;", "getExtras", "()Ljava/util/Map;", "copy", "equals", "", "other", "", "hashCode", "", "toString", "describeContents", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "coil-base_release"})
    @SourceDebugExtension(value={"SMAP\nMemoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCache.kt\ncoil/memory/MemoryCache$Key\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,216:1\n216#2,2:217\n*S KotlinDebug\n*F\n+ 1 MemoryCache.kt\ncoil/memory/MemoryCache$Key\n*L\n86#1:217,2\n*E\n"})
    public static final class Key
    implements Parcelable {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final String key;
        @NotNull
        private final Map<String, String> extras;
        @Deprecated
        @JvmField
        @NotNull
        public static final Parcelable.Creator<Key> CREATOR = (Parcelable.Creator)new Parcelable.Creator<Key>(){

            public Key createFromParcel(Parcel parcel) {
                String string = parcel.readString();
                Intrinsics.checkNotNull((Object)string);
                String key = string;
                int size2 = parcel.readInt();
                LinkedHashMap<K, V> extras = new LinkedHashMap<K, V>(size2);
                int n = 0;
                while (n < size2) {
                    String extraValue;
                    String extraKey;
                    int it = n++;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)parcel.readString());
                    Intrinsics.checkNotNull((Object)parcel.readString());
                    ((Map)extras).put(extraKey, extraValue);
                }
                return new Key(key, (Map<String, String>)extras);
            }

            public Key[] newArray(int size2) {
                return new Key[size2];
            }
        };

        public Key(@NotNull String key, @NotNull Map<String, String> extras) {
            this.key = key;
            this.extras = extras;
        }

        public /* synthetic */ Key(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            this(string, map);
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final Map<String, String> getExtras() {
            return this.extras;
        }

        @NotNull
        public final Key copy(@NotNull String key, @NotNull Map<String, String> extras) {
            return new Key(key, extras);
        }

        public static /* synthetic */ Key copy$default(Key key, String string, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                string = key.key;
            }
            if ((n & 2) != 0) {
                map = key.extras;
            }
            return key.copy(string, map);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Key && Intrinsics.areEqual((Object)this.key, (Object)((Key)other).key) && Intrinsics.areEqual(this.extras, ((Key)other).extras);
        }

        public int hashCode() {
            int result2 = this.key.hashCode();
            result2 = 31 * result2 + ((Object)this.extras).hashCode();
            return result2;
        }

        @NotNull
        public String toString() {
            return "Key(key=" + this.key + ", extras=" + this.extras + ')';
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            parcel.writeString(this.key);
            parcel.writeInt(this.extras.size());
            Map<String, String> $this$forEach$iv = this.extras;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                String key = entry.getKey();
                String value = entry.getValue();
                parcel.writeString(key);
                parcel.writeString(value);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcoil/memory/MemoryCache$Key$Companion;", "", "<init>", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcoil/memory/MemoryCache$Key;", "coil-base_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcoil/memory/MemoryCache$Value;", "", "bitmap", "Landroid/graphics/Bitmap;", "extras", "", "", "<init>", "(Landroid/graphics/Bitmap;Ljava/util/Map;)V", "getBitmap", "()Landroid/graphics/Bitmap;", "getExtras", "()Ljava/util/Map;", "copy", "equals", "", "other", "hashCode", "", "toString", "coil-base_release"})
    public static final class Value {
        @NotNull
        private final Bitmap bitmap;
        @NotNull
        private final Map<String, Object> extras;

        public Value(@NotNull Bitmap bitmap, @NotNull Map<String, ? extends Object> extras) {
            this.bitmap = bitmap;
            this.extras = extras;
        }

        public /* synthetic */ Value(Bitmap bitmap, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            this(bitmap, map);
        }

        @NotNull
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        @NotNull
        public final Map<String, Object> getExtras() {
            return this.extras;
        }

        @NotNull
        public final Value copy(@NotNull Bitmap bitmap, @NotNull Map<String, ? extends Object> extras) {
            return new Value(bitmap, extras);
        }

        public static /* synthetic */ Value copy$default(Value value, Bitmap bitmap, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                bitmap = value.bitmap;
            }
            if ((n & 2) != 0) {
                map = value.extras;
            }
            return value.copy(bitmap, map);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Value && Intrinsics.areEqual((Object)this.bitmap, (Object)((Value)other).bitmap) && Intrinsics.areEqual(this.extras, ((Value)other).extras);
        }

        public int hashCode() {
            int result2 = this.bitmap.hashCode();
            result2 = 31 * result2 + ((Object)this.extras).hashCode();
            return result2;
        }

        @NotNull
        public String toString() {
            return "Value(bitmap=" + this.bitmap + ", extras=" + this.extras + ')';
        }
    }
}

