/*
 * Decompiled with CFR 0.152.
 */
package io.coodoo.framework.listing.boundary;

import io.coodoo.framework.listing.boundary.ListingPredicate;
import io.coodoo.framework.listing.control.ListingConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

public class ListingParameters {
    @QueryParam(value="page")
    private Integer page;
    @QueryParam(value="limit")
    private Integer limit;
    @QueryParam(value="filter")
    private String filter;
    @QueryParam(value="sort")
    private String sortAttribute;
    @Context
    private UriInfo uriInfo;
    @QueryParam(value="index")
    private Integer index;
    private Map<String, String> filterAttributes = new HashMap<String, String>();
    private ListingPredicate predicate;

    public ListingParameters() {
    }

    public ListingParameters(Integer page, Integer limit, String sortAttribute) {
        this.page = page;
        this.limit = limit;
        this.sortAttribute = sortAttribute;
    }

    public Integer getPage() {
        if (this.page == null && this.limit != null && this.index != null) {
            int mod = this.index % this.limit;
            if (this.index == 0) {
                return ListingConfig.DEFAULT_PAGE;
            }
            if (mod == 0) {
                return this.index / this.limit;
            }
            return this.index / this.limit + 1;
        }
        if (this.page == null) {
            return ListingConfig.DEFAULT_PAGE;
        }
        if (this.page < 1) {
            return ListingConfig.DEFAULT_PAGE;
        }
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getLimit() {
        if (this.limit == null) {
            return ListingConfig.DEFAULT_LIMIT;
        }
        if (this.limit == 0) {
            return null;
        }
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public String getFilter() {
        return StringUtils.trimToNull((String)this.filter);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getSortAttribute() {
        if (StringUtils.isBlank((CharSequence)this.sortAttribute)) {
            return null;
        }
        if (this.sortAttribute.startsWith("-") || this.sortAttribute.startsWith("+")) {
            return this.sortAttribute.substring(1, this.sortAttribute.length());
        }
        return this.sortAttribute;
    }

    public void setSortAttribute(String sortAttribute) {
        this.sortAttribute = sortAttribute;
    }

    public boolean isSortAsc() {
        if (StringUtils.isBlank((CharSequence)this.sortAttribute)) {
            return true;
        }
        return !this.sortAttribute.startsWith("-");
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public Integer getIndex() {
        if (this.index == null && this.page != null) {
            return (this.page - 1) * this.limit;
        }
        if (this.index == null) {
            return ListingConfig.DEFAULT_INDEX;
        }
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void addFilterAttributes(String filter, String value) {
        this.filterAttributes.put(filter, value);
    }

    public Map<String, String> getFilterAttributes() {
        if (this.uriInfo != null) {
            MultivaluedMap queryParams = this.uriInfo.getQueryParameters();
            for (Map.Entry queryParam : queryParams.entrySet()) {
                String queryParamAttribute = (String)queryParam.getKey();
                if (StringUtils.isBlank((CharSequence)queryParamAttribute) || !queryParamAttribute.startsWith("filter-")) continue;
                queryParamAttribute = queryParamAttribute.substring("filter-".length(), queryParamAttribute.length());
                String filterVal = StringUtils.trimToNull((String)((String)((List)queryParam.getValue()).get(0)));
                if (filterVal == null) continue;
                this.filterAttributes.put(queryParamAttribute, filterVal);
            }
        }
        return this.filterAttributes;
    }

    public ListingPredicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(ListingPredicate predicate) {
        this.predicate = predicate;
    }
}

