/*
 * Decompiled with CFR 0.152.
 */
package io.coodoo.framework.listing.boundary;

import io.coodoo.framework.listing.boundary.ListingParameters;

public class Metadata {
    private long count;
    private int currentPage;
    private int numPages;
    private int limit;
    private String sort;
    private int startIndex;
    private int endIndex;

    public Metadata(Long count, ListingParameters listingQueryParams) {
        this(count, listingQueryParams.getPage(), listingQueryParams.getLimit(), listingQueryParams.getSortAttribute());
    }

    public Metadata(Long count, int currentPage, int itemsPerPage) {
        this(count, currentPage, itemsPerPage, null);
    }

    public Metadata(Long count, int currentPage, int limit, String sort) {
        this.count = count;
        this.currentPage = currentPage;
        this.limit = limit;
        this.sort = sort;
        this.numPages = count.intValue() / limit + (count.intValue() % limit != 0 ? 1 : 0);
        if (count < (long)limit) {
            this.numPages = 1;
        }
        this.startIndex = limit * currentPage - limit + 1;
        this.endIndex = limit * currentPage;
        if ((long)this.endIndex > count) {
            this.endIndex = count.intValue();
        }
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getNumPages() {
        return this.numPages;
    }

    public void setNumPages(int numPages) {
        this.numPages = numPages;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }
}

