/*
 * Decompiled with CFR 0.152.
 */
package io.coodoo.framework.listing.control;

import io.coodoo.framework.listing.boundary.ListingPredicate;
import io.coodoo.framework.listing.boundary.annotation.ListingFilterIgnore;
import io.coodoo.framework.listing.boundary.annotation.ListingLikeOnNumber;
import io.coodoo.framework.listing.control.ListingConfig;
import io.coodoo.framework.listing.control.ListingUtil;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;

public class ListingQuery<T> {
    private EntityManager entityManager;
    private CriteriaBuilder criteriaBuilder;
    private CriteriaQuery query;
    private Root<T> root;
    private Class<T> domainClass;
    private List<Predicate> whereConstraints = new ArrayList<Predicate>();

    public ListingQuery(EntityManager entityManager, Class<T> domainClass) {
        this.entityManager = entityManager;
        this.domainClass = domainClass;
        this.criteriaBuilder = entityManager.getCriteriaBuilder();
        this.query = this.criteriaBuilder.createQuery();
        this.root = this.query.from(domainClass);
    }

    public ListingQuery<T> filterAllAttributes(String filter) {
        if (!StringUtils.isBlank((CharSequence)filter)) {
            HashMap<String, String> filterAttributes = new HashMap<String, String>();
            filterAttributes.put(ListingConfig.FILTER_TYPE_DISJUNCTION, "this just enables an OR-statement for all the fields");
            for (Field field : ListingUtil.getFields(this.domainClass)) {
                if (!field.isAnnotationPresent(Column.class) || field.isAnnotationPresent(ListingFilterIgnore.class)) continue;
                filterAttributes.put(field.getName(), filter);
            }
            return this.filterByAttributes(filterAttributes);
        }
        return this;
    }

    public ListingQuery<T> filterByAttributes(Map<String, String> filterAttributes) {
        if (filterAttributes != null && !filterAttributes.isEmpty()) {
            ListingPredicate listingPredicate = new ListingPredicate().and();
            for (String attribute : filterAttributes.keySet()) {
                if (StringUtils.equals((CharSequence)ListingConfig.FILTER_TYPE_DISJUNCTION, (CharSequence)attribute)) {
                    listingPredicate = listingPredicate.or();
                }
                String filter = filterAttributes.get(attribute);
                if (StringUtils.contains((CharSequence)attribute, (CharSequence)ListingConfig.OPERATOR_OR)) {
                    listingPredicate.addPredicate(new ListingPredicate().or().predicates(ListingUtil.split(attribute).stream().map(orAttribute -> this.createListingPredicate((String)orAttribute, filter)).collect(Collectors.toList())));
                    continue;
                }
                listingPredicate.addPredicate(this.createListingPredicate(attribute, filter));
            }
            this.addToWhereConstraint(listingPredicate);
        }
        return this;
    }

    public ListingQuery<T> filterByPredicate(ListingPredicate listingPredicate) {
        this.addToWhereConstraint(listingPredicate);
        return this;
    }

    private void addToWhereConstraint(ListingPredicate listingPredicate) {
        if (listingPredicate != null) {
            Predicate predicate = null;
            ArrayList<ListingPredicate> filters = new ArrayList<ListingPredicate>();
            Map<String, Field> fieldMap = ListingUtil.getFields(this.domainClass).stream().collect(Collectors.toMap(field -> field.getName(), field -> field));
            if (listingPredicate.hasPredicates()) {
                filters.addAll(listingPredicate.getPredicates());
            } else {
                filters.add(new ListingPredicate().filter(listingPredicate.getAttribute(), listingPredicate.getFilter()));
            }
            predicate = this.filterByPredicateTree(listingPredicate.isDisjunctive(), listingPredicate.isNegation(), filters, fieldMap);
            if (predicate != null) {
                if (listingPredicate.isNegation()) {
                    predicate = this.criteriaBuilder.not((Expression)predicate);
                }
                this.whereConstraints.add(predicate);
            }
        }
    }

    private ListingPredicate createListingPredicate(String attribute, String filter) {
        if (StringUtils.contains((CharSequence)filter, (CharSequence)ListingConfig.OPERATOR_OR) || StringUtils.contains((CharSequence)filter, (CharSequence)ListingConfig.OPERATOR_OR_WORD)) {
            List<String> orList = ListingUtil.split(filter.replaceAll(ListingConfig.OPERATOR_OR_WORD, ListingConfig.OPERATOR_OR));
            if (orList.size() > ListingConfig.OR_TO_IN_LIMIT) {
                return new ListingPredicate().in().filter(attribute, filter.replaceAll(ListingConfig.OPERATOR_OR_WORD, ListingConfig.OPERATOR_OR));
            }
            return new ListingPredicate().or().predicates(orList.stream().map(orfilter -> this.createListingPredicateFilter(attribute, (String)orfilter)).collect(Collectors.toList()));
        }
        return this.createListingPredicateFilter(attribute, filter);
    }

    private ListingPredicate createListingPredicateFilter(String attribute, String filter) {
        if (filter.startsWith(ListingConfig.OPERATOR_NOT)) {
            return new ListingPredicate().not().filter(attribute, filter.replaceFirst(ListingConfig.OPERATOR_NOT, ""));
        }
        if (filter.startsWith(ListingConfig.OPERATOR_NOT_WORD)) {
            return new ListingPredicate().not().filter(attribute, filter.replaceFirst(ListingConfig.OPERATOR_NOT_WORD, ""));
        }
        return new ListingPredicate().filter(attribute, filter);
    }

    private Predicate filterByPredicateTree(boolean disjunctive, boolean negation, List<ListingPredicate> listingPredicates, Map<String, Field> fieldMap) {
        if (listingPredicates != null && !listingPredicates.isEmpty()) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (ListingPredicate listingPredicate : listingPredicates) {
                Predicate predicate = null;
                if (listingPredicate.hasPredicates()) {
                    predicate = this.filterByPredicateTree(listingPredicate.isDisjunctive(), listingPredicate.isNegation(), listingPredicate.getPredicates(), fieldMap);
                } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{listingPredicate.getAttribute()}) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{listingPredicate.getFilter()})) {
                    if (!fieldMap.containsKey(listingPredicate.getAttribute())) continue;
                    predicate = listingPredicate.isIn() ? this.createInPredicate(ListingUtil.split(listingPredicate.getFilter()), fieldMap.get(listingPredicate.getAttribute())) : this.createPredicate(listingPredicate.getFilter(), fieldMap.get(listingPredicate.getAttribute()));
                }
                if (predicate == null) continue;
                predicates.add(predicate);
            }
            if (!predicates.isEmpty()) {
                Predicate predicate = null;
                predicate = disjunctive ? this.criteriaBuilder.or(predicates.toArray(new Predicate[predicates.size()])) : this.criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
                if (negation) {
                    return this.criteriaBuilder.not((Expression)predicate);
                }
                return predicate;
            }
        }
        return null;
    }

    private Predicate createPredicate(String filter, Field field) {
        if (filter.matches("^" + ListingConfig.OPERATOR_NULL + "$")) {
            return this.criteriaBuilder.isNull((Expression)this.root.get(field.getName()));
        }
        if (field.getType().equals(String.class)) {
            if (ListingUtil.isQuoted(filter)) {
                return this.criteriaBuilder.equal((Expression)this.root.get(field.getName()), (Object)ListingUtil.removeQuotes(filter));
            }
            return this.criteriaBuilder.like((Expression)this.root.get(field.getName()), ListingUtil.likeValue(filter));
        }
        if (field.getType().equals(LocalDateTime.class) || field.getType().equals(Date.class)) {
            LocalDateTime startDate = null;
            LocalDateTime endDate = null;
            if (filter.contains("-")) {
                String[] dateRange = filter.split("-");
                if (dateRange.length == 2) {
                    startDate = ListingUtil.parseFilterDate(dateRange[0], false);
                    endDate = ListingUtil.parseFilterDate(dateRange[1], true);
                }
            } else {
                startDate = ListingUtil.parseFilterDate(filter, false);
                endDate = ListingUtil.parseFilterDate(filter, true);
            }
            if (startDate != null && endDate != null) {
                Predicate date = this.criteriaBuilder.conjunction();
                if (field.getType().equals(Date.class)) {
                    date = this.criteriaBuilder.and((Expression)date, (Expression)this.criteriaBuilder.greaterThan((Expression)this.root.get(field.getName()), (Comparable)Date.from(startDate.toInstant(ZoneOffset.UTC))));
                    date = this.criteriaBuilder.and((Expression)date, (Expression)this.criteriaBuilder.lessThan((Expression)this.root.get(field.getName()), (Comparable)Date.from(endDate.toInstant(ZoneOffset.UTC))));
                } else {
                    date = this.criteriaBuilder.and((Expression)date, (Expression)this.criteriaBuilder.greaterThan((Expression)this.root.get(field.getName()), (Comparable)startDate));
                    date = this.criteriaBuilder.and((Expression)date, (Expression)this.criteriaBuilder.lessThan((Expression)this.root.get(field.getName()), (Comparable)endDate));
                }
                return this.criteriaBuilder.and(new Predicate[]{date});
            }
        }
        if (field.getType() instanceof Class && field.getType().isEnum()) {
            if (ListingUtil.isQuoted(filter)) {
                try {
                    Object enumValue = Enum.valueOf(field.getType(), ListingUtil.removeQuotes(filter));
                    return this.criteriaBuilder.equal((Expression)this.root.get(field.getName()), enumValue);
                }
                catch (IllegalArgumentException enumValue) {
                    // empty catch block
                }
            }
            Predicate possibleEnumValues = this.criteriaBuilder.disjunction();
            for (Object enumValue : field.getType().getEnumConstants()) {
                if (!enumValue.toString().toUpperCase().contains(filter.toUpperCase())) continue;
                Predicate possibleEnumValue = this.criteriaBuilder.equal((Expression)this.root.get(field.getName()), enumValue);
                possibleEnumValues = this.criteriaBuilder.or((Expression)possibleEnumValues, (Expression)possibleEnumValue);
            }
            return this.criteriaBuilder.and(new Predicate[]{possibleEnumValues});
        }
        if (field.getType().equals(Long.class) || field.getType().equals(Long.TYPE)) {
            if (filter.matches("^-?\\d{1,37}$")) {
                if (field.isAnnotationPresent(ListingLikeOnNumber.class)) {
                    return this.criteriaBuilder.like(this.root.get(field.getName()).as(String.class), ListingUtil.likeValue(filter));
                }
                return this.criteriaBuilder.equal((Expression)this.root.get(field.getName()), (Object)Long.valueOf(filter));
            }
            Matcher longRange = Pattern.compile("(^-?\\d{1,37})-(-?\\d{1,37}$)").matcher(filter);
            if (longRange.find()) {
                return this.criteriaBuilder.between((Expression)this.root.get(field.getName()), (Comparable)Long.valueOf(longRange.group(1)), (Comparable)Long.valueOf(longRange.group(2)));
            }
        }
        if (field.getType().equals(Integer.class) || field.getType().equals(Integer.TYPE)) {
            if (filter.matches("^-?\\d{1,10}$")) {
                if (field.isAnnotationPresent(ListingLikeOnNumber.class)) {
                    return this.criteriaBuilder.like(this.root.get(field.getName()).as(String.class), ListingUtil.likeValue(filter));
                }
                return this.criteriaBuilder.equal((Expression)this.root.get(field.getName()), (Object)Integer.valueOf(filter));
            }
            Matcher intRange = Pattern.compile("(^-?\\d{1,10})-(-?\\d{1,10}$)").matcher(filter);
            if (intRange.find()) {
                return this.criteriaBuilder.between((Expression)this.root.get(field.getName()), (Comparable)Integer.valueOf(intRange.group(1)), (Comparable)Integer.valueOf(intRange.group(2)));
            }
        }
        if (field.getType().equals(Short.class) || field.getType().equals(Short.TYPE)) {
            if (filter.matches("^-?\\d{1,5}$")) {
                if (field.isAnnotationPresent(ListingLikeOnNumber.class)) {
                    return this.criteriaBuilder.like(this.root.get(field.getName()).as(String.class), ListingUtil.likeValue(filter));
                }
                return this.criteriaBuilder.equal((Expression)this.root.get(field.getName()), (Object)Short.valueOf(filter));
            }
            Matcher shortRange = Pattern.compile("(^-?\\d{1,5})-(-?\\d{1,5}$)").matcher(filter);
            if (shortRange.find()) {
                return this.criteriaBuilder.between((Expression)this.root.get(field.getName()), (Comparable)Short.valueOf(shortRange.group(1)), (Comparable)Short.valueOf(shortRange.group(2)));
            }
        }
        if ((field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) && (filter.toLowerCase().equals("true") || filter.toLowerCase().equals("false"))) {
            Boolean booleanValue = filter.toLowerCase().equals("true");
            return this.criteriaBuilder.equal((Expression)this.root.get(field.getName()), (Object)booleanValue);
        }
        return null;
    }

    private Predicate createInPredicate(List<String> inList, Field field) {
        if (field.getType().equals(String.class)) {
            return this.criteriaBuilder.isTrue((Expression)this.root.get(field.getName()).in(inList));
        }
        if (field.getType().equals(Long.class) || field.getType().equals(Long.TYPE)) {
            List inListLong = inList.stream().map(Long::parseLong).collect(Collectors.toList());
            return this.criteriaBuilder.isTrue((Expression)this.root.get(field.getName()).in(inListLong));
        }
        if (field.getType().equals(Integer.class) || field.getType().equals(Integer.TYPE)) {
            List inListInt = inList.stream().map(Integer::parseInt).collect(Collectors.toList());
            return this.criteriaBuilder.isTrue((Expression)this.root.get(field.getName()).in(inListInt));
        }
        if (field.getType().equals(Short.class) || field.getType().equals(Short.TYPE)) {
            List inListShort = inList.stream().map(Short::parseShort).collect(Collectors.toList());
            return this.criteriaBuilder.isTrue((Expression)this.root.get(field.getName()).in(inListShort));
        }
        if (field.getType() instanceof Class && field.getType().isEnum()) {
            ArrayList inListEnum = new ArrayList();
            for (String enumString : inList) {
                try {
                    inListEnum.add(Enum.valueOf(field.getType(), enumString));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return this.criteriaBuilder.isTrue((Expression)this.root.get(field.getName()).in(inListEnum));
        }
        return null;
    }

    public ListingQuery<T> filter(String filter, String ... attributes) {
        if (!StringUtils.isBlank((CharSequence)filter)) {
            filter = ListingUtil.likeValue(filter);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (String attribute : attributes) {
                predicates.add(this.criteriaBuilder.like(this.criteriaBuilder.lower((Expression)this.root.get(attribute)), filter));
            }
            Predicate filterConstraint = this.criteriaBuilder.or(predicates.toArray(new Predicate[predicates.size()]));
            this.whereConstraints.add(filterConstraint);
        }
        return this;
    }

    public ListingQuery<T> addIsNullConstraint(String attribute) {
        this.whereConstraints.add(this.criteriaBuilder.isNull((Expression)this.root.get(attribute)));
        return this;
    }

    public ListingQuery<T> addEqualsConstraint(String attribute, Enum value) {
        this.whereConstraints.add(this.criteriaBuilder.equal((Expression)this.root.get(attribute), (Object)value));
        return this;
    }

    public ListingQuery<T> addEqualsNotConstraint(String attribute, Enum value) {
        this.whereConstraints.add(this.criteriaBuilder.notEqual((Expression)this.root.get(attribute), (Object)value));
        return this;
    }

    public ListingQuery<T> sort(String attribute, boolean asc) {
        if (attribute == null) {
            return this;
        }
        if (asc) {
            this.query.orderBy(new Order[]{this.criteriaBuilder.asc((Expression)this.root.get(attribute))});
        } else {
            this.query.orderBy(new Order[]{this.criteriaBuilder.desc((Expression)this.root.get(attribute))});
        }
        return this;
    }

    public CriteriaQuery<T> getQuery() {
        this.query.select(this.root);
        this.query.where((Expression)this.criteriaBuilder.and(this.whereConstraints.toArray(new Predicate[this.whereConstraints.size()])));
        return this.query;
    }

    public CriteriaQuery<Long> getQueryForCount() {
        this.query.select((Selection)this.criteriaBuilder.count(this.root));
        this.query.where((Expression)this.criteriaBuilder.and(this.whereConstraints.toArray(new Predicate[this.whereConstraints.size()])));
        return this.query;
    }

    public List<T> list() {
        return this.list(null, null);
    }

    public List<T> list(Integer startPosition, Integer limit) {
        TypedQuery typedQuery = this.entityManager.createQuery(this.getQuery());
        if (startPosition != null) {
            typedQuery.setFirstResult(startPosition.intValue());
        }
        if (limit != null) {
            typedQuery.setMaxResults(limit.intValue());
        }
        return typedQuery.getResultList();
    }

    public Long count() {
        TypedQuery q = this.entityManager.createQuery(this.getQueryForCount());
        return (Long)q.getSingleResult();
    }
}

