/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api;

import cucumber.api.TableConverter;
import cucumber.runtime.CucumberException;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.table.DiffableRow;
import cucumber.runtime.table.TableDiffException;
import cucumber.runtime.table.TableDiffer;
import cucumber.runtime.table.TablePrinter;
import cucumber.runtime.xstream.LocalizedXStreams;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DataTable {
    private final List<List<String>> raw;
    private final PickleTable pickleTable;
    private final TableConverter tableConverter;

    public static DataTable create(List<?> raw) {
        return DataTable.create(raw, Locale.getDefault(), null, new String[0]);
    }

    public static DataTable create(List<?> raw, String format, String ... columnNames) {
        return DataTable.create(raw, Locale.getDefault(), format, columnNames);
    }

    public static DataTable create(List<?> raw, Locale locale, String ... columnNames) {
        return DataTable.create(raw, locale, null, columnNames);
    }

    private static DataTable create(List<?> raw, Locale locale, String format, String ... columnNames) {
        ParameterInfo parameterInfo = new ParameterInfo(null, format, null, null);
        cucumber.runtime.table.TableConverter tableConverter = new cucumber.runtime.table.TableConverter(new LocalizedXStreams(Thread.currentThread().getContextClassLoader()).get(locale), parameterInfo);
        return tableConverter.toTable(raw, columnNames);
    }

    public DataTable(PickleTable pickleTable, TableConverter tableConverter) {
        this.pickleTable = pickleTable;
        this.tableConverter = tableConverter;
        int columns = pickleTable.getRows().isEmpty() ? 0 : ((PickleRow)pickleTable.getRows().get(0)).getCells().size();
        ArrayList raw = new ArrayList();
        for (PickleRow row : pickleTable.getRows()) {
            ArrayList<String> list = new ArrayList<String>();
            for (PickleCell cell : row.getCells()) {
                list.add(cell.getValue());
            }
            if (columns != row.getCells().size()) {
                throw new CucumberException(String.format("Table is unbalanced: expected %s column(s) but found %s.", columns, row.getCells().size()));
            }
            raw.add(Collections.unmodifiableList(list));
        }
        this.raw = Collections.unmodifiableList(raw);
    }

    private DataTable(PickleTable pickleTable, List<List<String>> raw, TableConverter tableConverter) {
        this.pickleTable = pickleTable;
        this.tableConverter = tableConverter;
        this.raw = Collections.unmodifiableList(raw);
    }

    public List<List<String>> raw() {
        return this.raw;
    }

    public <K, V> List<Map<K, V>> asMaps(Class<K> keyType, Class<V> valueType) {
        return this.tableConverter.toMaps(this, keyType, valueType);
    }

    public <K, V> Map<K, V> asMap(Class<K> keyType, Class<V> valueType) {
        return this.tableConverter.toMap(this, keyType, valueType);
    }

    public <T> List<T> asList(Class<T> itemType) {
        return this.tableConverter.toList(this, itemType);
    }

    public <T> List<List<T>> asLists(Class<T> itemType) {
        return this.tableConverter.toLists(this, itemType);
    }

    public List<String> topCells() {
        return this.raw.isEmpty() ? Collections.emptyList() : this.raw.get(0);
    }

    public List<List<String>> cells(int firstRow) {
        return this.raw.subList(firstRow, this.raw.size());
    }

    public DataTable toTable(List<?> raw, String ... columnNames) {
        return this.tableConverter.toTable(raw, columnNames);
    }

    public void diff(List<?> other) throws TableDiffException {
        List<String> topCells = this.topCells();
        DataTable otherTable = this.toTable(other, topCells.toArray(new String[topCells.size()]));
        this.diff(otherTable);
    }

    public void diff(DataTable other) throws TableDiffException {
        new TableDiffer(this, other).calculateDiffs();
    }

    public void unorderedDiff(DataTable other) throws TableDiffException {
        new TableDiffer(this, other).calculateUnorderedDiffs();
    }

    public void unorderedDiff(List<?> other) throws TableDiffException {
        List<String> topCells = this.topCells();
        DataTable otherTable = this.toTable(other, topCells.toArray(new String[topCells.size()]));
        this.unorderedDiff(otherTable);
    }

    public List<PickleRow> getPickleRows() {
        return Collections.unmodifiableList(this.pickleTable.getRows());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        TablePrinter printer = this.createTablePrinter();
        printer.printTable(this.raw, result);
        return result.toString();
    }

    public List<DiffableRow> diffableRows() {
        ArrayList<DiffableRow> result = new ArrayList<DiffableRow>();
        List<List<String>> convertedRows = this.raw();
        for (int i = 0; i < convertedRows.size(); ++i) {
            result.add(new DiffableRow(this.getPickleRows().get(i), convertedRows.get(i)));
        }
        return result;
    }

    public TableConverter getTableConverter() {
        return this.tableConverter;
    }

    public DataTable transpose() {
        ArrayList<List<String>> transposed = new ArrayList<List<String>>();
        for (int i = 0; i < this.pickleTable.getRows().size(); ++i) {
            PickleRow pickleRow = (PickleRow)this.pickleTable.getRows().get(i);
            for (int j = 0; j < pickleRow.getCells().size(); ++j) {
                ArrayList<String> row = null;
                if (j < transposed.size()) {
                    row = (ArrayList<String>)transposed.get(j);
                }
                if (row == null) {
                    row = new ArrayList<String>();
                    transposed.add(row);
                }
                row.add(((PickleCell)pickleRow.getCells().get(j)).getValue());
            }
        }
        return new DataTable(this.pickleTable, transposed, this.tableConverter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataTable)) {
            return false;
        }
        DataTable dataTable = (DataTable)o;
        return this.raw.equals(dataTable.raw);
    }

    public int hashCode() {
        return this.raw.hashCode();
    }

    protected TablePrinter createTablePrinter() {
        return new TablePrinter();
    }
}

