/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api;

import java.io.PrintWriter;
import java.io.StringWriter;

public class Result {
    private static final long serialVersionUID = 1L;
    private final Type status;
    private final Long duration;
    private final Throwable error;
    public static final Result SKIPPED = new Result(Type.SKIPPED, null, null);
    public static final Result UNDEFINED = new Result(Type.UNDEFINED, null, null);

    public Result(Type status, Long duration, Throwable error) {
        this.status = status;
        this.duration = duration;
        this.error = error;
    }

    public Type getStatus() {
        return this.status;
    }

    public Long getDuration() {
        return this.duration;
    }

    public String getErrorMessage() {
        return this.error != null ? this.getErrorMessage(this.error) : null;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean is(Type status) {
        return this.status == status;
    }

    public boolean isOk(boolean isStrict) {
        return this.hasAlwaysOkStatus() || !isStrict && this.hasOkWhenNotStrictStatus();
    }

    private boolean hasAlwaysOkStatus() {
        return this.is(Type.PASSED) || this.is(Type.SKIPPED);
    }

    private boolean hasOkWhenNotStrictStatus() {
        return this.is(Type.UNDEFINED) || this.is(Type.PENDING);
    }

    private String getErrorMessage(Throwable error) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        error.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    public static enum Type {
        PASSED,
        SKIPPED,
        PENDING,
        UNDEFINED,
        AMBIGUOUS,
        FAILED;


        public static Type fromLowerCaseName(String lowerCaseName) {
            return Type.valueOf(lowerCaseName.toUpperCase());
        }

        public String lowerCaseName() {
            return this.name().toLowerCase();
        }

        public String firstLetterCapitalizedName() {
            return this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
        }
    }
}

