/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.databases;

import io.debezium.testing.openshift.tools.OpenShiftUtils;
import io.debezium.testing.openshift.tools.YAML;
import io.debezium.testing.openshift.tools.databases.DatabaseController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseDeployer<T extends DatabaseDeployer, C extends DatabaseController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseDeployer.class);
    private final OpenShiftClient ocp;
    private final OpenShiftUtils ocpUtils;
    private final String dbType;
    private String project;
    private Deployment deployment;
    private List<Service> services;

    public DatabaseDeployer(String dbType, OpenShiftClient ocp) {
        this.dbType = dbType;
        this.ocp = ocp;
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    public T withProject(String project) {
        this.project = project;
        return this.getThis();
    }

    public T withDeployment(String yamlPath) {
        return this.withDeployment(YAML.fromResource(yamlPath, Deployment.class));
    }

    public T withDeployment(Deployment deployment) {
        this.deployment = deployment;
        return this.getThis();
    }

    public T withServices(String ... yamlPath) {
        List<Service> services = Arrays.stream(yamlPath).map(p -> YAML.fromResource(p, Service.class)).collect(Collectors.toList());
        return this.withServices(services);
    }

    public T withServices(Collection<Service> services) {
        this.services = new ArrayList<Service>(services);
        return this.getThis();
    }

    public C deploy() {
        if (this.deployment == null) {
            throw new IllegalStateException("Deployment configuration not available");
        }
        LOGGER.info("Deploying database");
        Deployment dep = (Deployment)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).createOrReplace((Object[])new Deployment[]{this.deployment});
        List svcs = this.services.stream().map(s -> (Service)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).createOrReplace((Object[])new Service[]{s})).collect(Collectors.toList());
        this.ocpUtils.waitForPods(this.project, dep.getMetadata().getLabels());
        LOGGER.info("Database deployed successfully");
        this.deployment = dep;
        this.services = svcs;
        return this.getController(dep, this.services, this.dbType, this.ocp);
    }

    public abstract T getThis();

    public abstract C getController(Deployment var1, List<Service> var2, String var3, OpenShiftClient var4);
}

