/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.strimzi.api.kafka.model.KafkaConnector;
import io.strimzi.api.kafka.model.KafkaConnectorBuilder;
import io.strimzi.api.kafka.model.KafkaConnectorFluent;
import java.util.HashMap;
import java.util.Map;

public class ConnectorConfigBuilder {
    private final Map<String, Object> config;
    private final ObjectMapper mapper = new ObjectMapper();

    public ConnectorConfigBuilder() {
        this.config = new HashMap<String, Object>();
    }

    public ConnectorConfigBuilder put(String key, Object value) {
        this.config.put(key, value);
        return this;
    }

    public Map<String, Object> get() {
        return this.config;
    }

    public String getJsonString() {
        try {
            return this.mapper.writeValueAsString(this.config);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to convert connector config to JSON String");
        }
    }

    public KafkaConnector getCustomResource() {
        HashMap<String, Object> crConfig = new HashMap<String, Object>(this.config);
        KafkaConnectorBuilder connectorBuilder = new KafkaConnectorBuilder();
        return ((KafkaConnectorBuilder)((KafkaConnectorFluent.SpecNested)((KafkaConnectorFluent.SpecNested)((KafkaConnectorFluent.SpecNested)((KafkaConnectorBuilder)((KafkaConnectorFluent.MetadataNested)connectorBuilder.withNewMetadata().withLabels(new HashMap())).endMetadata()).withNewSpec().withClassName((String)crConfig.remove("connector.class"))).withTasksMax((Integer)crConfig.remove("task.max"))).withConfig(crConfig)).endSpec()).build();
    }
}

