/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.servlets.tasks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import io.dropwizard.servlets.tasks.Task;
import java.io.PrintWriter;

public class GarbageCollectionTask
extends Task {
    private final Runtime runtime;

    public GarbageCollectionTask() {
        this(Runtime.getRuntime());
    }

    public GarbageCollectionTask(Runtime runtime) {
        super("gc");
        this.runtime = runtime;
    }

    @Override
    public void execute(ImmutableMultimap<String, String> parameters, PrintWriter output) {
        int count = GarbageCollectionTask.parseRuns(parameters);
        for (int i = 0; i < count; ++i) {
            output.println("Running GC...");
            output.flush();
            this.runtime.gc();
        }
        output.println("Done!");
    }

    private static int parseRuns(ImmutableMultimap<String, String> parameters) {
        ImmutableList runs = parameters.get((Object)"runs").asList();
        if (runs.isEmpty()) {
            return 1;
        }
        try {
            return Integer.parseInt((String)runs.get(0));
        }
        catch (NumberFormatException ignored) {
            return 1;
        }
    }
}

