/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.core;

import io.engineblock.activityapi.core.ActivityType;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownDocInfo {
    private static final Logger logger = LoggerFactory.getLogger(MarkdownDocInfo.class);

    public static Optional<String> forHelpTopic(String topic) {
        String help = null;
        try {
            help = new MarkdownDocInfo().forActivityInstance(topic);
            return Optional.ofNullable(help);
        }
        catch (Exception e) {
            logger.debug("Did not find help topic for activity instance: " + topic);
            try {
                help = new MarkdownDocInfo().forResourceMarkdown(topic, "docs/");
                return Optional.ofNullable(help);
            }
            catch (Exception e2) {
                logger.debug("Did not find help topic for generic markdown file: " + topic + "(.md)");
                return Optional.empty();
            }
        }
    }

    public String forResourceMarkdown(String s, String ... additionalSearchPaths) {
        String docFileName = s + ".md";
        ArrayList<String> searchIn = new ArrayList<String>();
        searchIn.add(docFileName);
        Arrays.stream(additionalSearchPaths).map(path -> path + docFileName).forEach(searchIn::add);
        logger.info("loading doc file for topic:" + docFileName);
        Optional<InputStream> found = searchIn.stream().map(this.getClass().getClassLoader()::getResourceAsStream).filter(Objects::nonNull).findFirst();
        InputStream stream = found.orElseThrow(() -> new RuntimeException("Unable to find docstream in classpath: " + docFileName));
        String docInfo = "";
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(stream));){
            docInfo = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to buffer data from docstream: " + docFileName + ":" + t);
        }
        return docInfo;
    }

    public String forActivityInstance(String s) {
        ActivityType activityType = (ActivityType)ActivityType.FINDER.getOrThrow(s);
        return this.forResourceMarkdown(activityType.getName() + ".md", "docs/");
    }
}

