/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.core;

import io.engineblock.activityapi.core.Activity;
import io.engineblock.activityapi.core.ActivityType;
import io.engineblock.activityapi.core.ProgressMeter;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.ParameterMap;
import io.engineblock.core.ActivityExecutor;
import io.engineblock.metrics.ActivityMetrics;
import java.io.PrintStream;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioController {
    private static final Logger logger = LoggerFactory.getLogger(ScenarioController.class);
    private final Map<String, ActivityExecutor> activityExecutors = new ConcurrentHashMap<String, ActivityExecutor>();

    public synchronized void start(ActivityDef activityDef) {
        this.getActivityExecutor(activityDef, true).startActivity();
    }

    public synchronized void start(Map<String, String> activityDefMap) {
        ActivityDef ad = new ActivityDef(new ParameterMap(activityDefMap));
        this.start(ad);
    }

    public synchronized void start(String alias) {
        this.start(ActivityDef.parseActivityDef((String)alias));
    }

    public synchronized void run(int timeout, Map<String, String> activityDefMap) {
        ActivityDef ad = new ActivityDef(new ParameterMap(activityDefMap));
        this.run(timeout, ad);
    }

    public synchronized void run(int timeout, ActivityDef activityDef) {
        ActivityExecutor activityExecutor = this.getActivityExecutor(activityDef, true);
        activityExecutor.startActivity();
        activityExecutor.awaitCompletion(timeout);
    }

    public synchronized void run(int timeout, String activityDefString) {
        ActivityDef activityDef = ActivityDef.parseActivityDef((String)activityDefString);
        this.run(timeout, activityDef);
    }

    public synchronized void run(Map<String, String> activityDefMap) {
        this.run(Integer.MAX_VALUE, activityDefMap);
    }

    public synchronized void run(String activityDefString) {
        this.run(Integer.MAX_VALUE, activityDefString);
    }

    public synchronized void run(ActivityDef activityDef) {
        this.run(Integer.MAX_VALUE, activityDef);
    }

    public boolean isRunningActivity(String alias) {
        return this.isRunningActivity(this.aliasToDef(alias));
    }

    public boolean isRunningActivity(ActivityDef activityDef) {
        ActivityExecutor activityExecutor = this.getActivityExecutor(activityDef, false);
        return activityExecutor != null && activityExecutor.isRunning();
    }

    public boolean isRunningActivity(Map<String, String> activityDefMap) {
        ActivityDef ad = new ActivityDef(new ParameterMap(activityDefMap));
        return this.isRunningActivity(ad);
    }

    public synchronized void stop(ActivityDef activityDef) {
        ActivityExecutor activityExecutor = this.getActivityExecutor(activityDef, false);
        if (activityExecutor == null) {
            throw new RuntimeException("could not stop missing activity:" + activityDef);
        }
        activityExecutor.stopActivity();
    }

    public synchronized void stop(Map<String, String> activityDefMap) {
        ActivityDef ad = new ActivityDef(new ParameterMap(activityDefMap));
        this.stop(ad);
    }

    public synchronized void stop(String alias) {
        this.stop(this.aliasToDef(alias));
    }

    public synchronized void modify(String alias, String param, String value) {
        if (param.equals("alias")) {
            throw new InvalidParameterException("It is not allowed to change the name of an existing activity.");
        }
        ActivityExecutor activityExecutor = this.getActivityExecutor(alias);
        ParameterMap params = activityExecutor.getActivityDef().getParams();
        params.set(param, (Object)value);
    }

    public synchronized void apply(Map<String, String> appliedParams) {
        String alias = appliedParams.get("alias");
        if (alias == null) {
            throw new RuntimeException("alias must be provided");
        }
        ActivityExecutor executor = this.activityExecutors.get(alias);
        if (executor == null) {
            logger.info("started scenario from apply:" + alias);
            this.start(appliedParams);
            return;
        }
        ParameterMap previousMap = executor.getActivityDef().getParams();
        for (String paramName : appliedParams.keySet()) {
            String appliedVal = appliedParams.get(paramName);
            Optional prevVal = previousMap.getOptionalString(paramName);
            if (prevVal.isPresent() && ((String)prevVal.get()).equals(appliedVal)) continue;
            logger.info("applying new value to activity '" + alias + "': '" + (String)prevVal.get() + "' -> '" + appliedVal + "'");
            previousMap.set(paramName, (Object)appliedVal);
        }
    }

    private ActivityExecutor getActivityExecutor(String activityAlias) {
        Optional<ActivityExecutor> executor = Optional.ofNullable(this.activityExecutors.get(activityAlias));
        return executor.orElseThrow(() -> new RuntimeException("ActivityExecutor for alias " + activityAlias + " not found."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivityExecutor getActivityExecutor(ActivityDef activityDef, boolean createIfMissing) {
        Map<String, ActivityExecutor> map = this.activityExecutors;
        synchronized (map) {
            ActivityExecutor executor = this.activityExecutors.get(activityDef.getAlias());
            if (executor == null && createIfMissing) {
                String activityTypeName = activityDef.getParams().getOptionalString("type").orElse("diag");
                ActivityType activityType = (ActivityType)ActivityType.FINDER.getOrThrow(activityTypeName);
                executor = new ActivityExecutor(activityType.getAssembledActivity(activityDef, this.getActivityMap()));
                this.activityExecutors.put(activityDef.getAlias(), executor);
            }
            return executor;
        }
    }

    public void waitMillis(long waitMillis) {
        logger.trace("#> waitMillis(" + waitMillis + ")");
        long endTime = System.currentTimeMillis() + waitMillis;
        while (waitMillis > 0L) {
            try {
                Thread.sleep(waitMillis);
            }
            catch (InterruptedException spurrious) {
                waitMillis = endTime - System.currentTimeMillis();
                continue;
            }
            waitMillis = 0L;
        }
    }

    public Set<String> getAliases() {
        return this.activityExecutors.keySet();
    }

    public List<ActivityDef> getActivityDefs() {
        return this.activityExecutors.values().stream().map(ActivityExecutor::getActivityDef).collect(Collectors.toList());
    }

    public ActivityDef getActivityDef(String alias) {
        return this.getActivityExecutor(alias).getActivityDef();
    }

    public void forceStopScenario(int waitTimeMillis) {
        logger.warn("Scenario force stopped.");
        this.activityExecutors.values().forEach(a -> a.forceStopExecutor(waitTimeMillis));
    }

    public boolean awaitCompletion(int waitTimeMillis) {
        boolean completed = false;
        for (ActivityExecutor executor : this.activityExecutors.values()) {
            if (executor.awaitCompletion(waitTimeMillis)) continue;
            return false;
        }
        return true;
    }

    private ActivityDef aliasToDef(String alias) {
        if (alias.contains("=")) {
            return ActivityDef.parseActivityDef((String)alias);
        }
        return ActivityDef.parseActivityDef((String)("alias=" + alias + ";"));
    }

    public boolean awaitActivity(Map<String, String> activityDefMap) {
        ActivityDef ad = new ActivityDef(new ParameterMap(activityDefMap));
        return this.awaitActivity(ad);
    }

    public boolean awaitActivity(String alias) {
        ActivityDef toAwait = this.aliasToDef(alias);
        return this.awaitActivity(toAwait);
    }

    public boolean awaitActivity(ActivityDef activityDef) {
        ActivityExecutor activityExecutor = this.getActivityExecutor(activityDef, false);
        if (activityExecutor == null) {
            throw new RuntimeException("Could not await missing activity: " + activityDef);
        }
        return activityExecutor.awaitFinish(Integer.MAX_VALUE);
    }

    public Map<String, ActivityExecutor> getActivityExecutorMap() {
        return Collections.unmodifiableMap(this.activityExecutors);
    }

    public void reportMetrics() {
        ActivityMetrics.reportTo((PrintStream)System.out);
    }

    private Map<String, Activity> getActivityMap() {
        HashMap<String, Activity> activityMap = new HashMap<String, Activity>();
        for (Map.Entry<String, ActivityExecutor> entry : this.activityExecutors.entrySet()) {
            activityMap.put(entry.getKey(), entry.getValue().getActivity());
        }
        return activityMap;
    }

    public Collection<ProgressMeter> getProgressMeters() {
        return this.activityExecutors.values().stream().map(e -> e).collect(Collectors.toList());
    }
}

