/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.core;

import io.engineblock.activityapi.core.Activity;
import io.engineblock.activityapi.core.ActivityController;
import io.engineblock.activityapi.core.ActivityDefObserver;
import io.engineblock.activityapi.core.Motor;
import io.engineblock.activityapi.core.ProgressMeter;
import io.engineblock.activityapi.core.RunState;
import io.engineblock.activityapi.core.Stoppable;
import io.engineblock.activityapi.input.Input;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.ParameterMap;
import io.engineblock.activityimpl.SlotStateTracker;
import io.engineblock.activityimpl.input.ProgressCapable;
import io.engineblock.core.ActivityExceptionHandler;
import io.engineblock.core.IndexedThreadFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityExecutor
implements ActivityController,
ParameterMap.Listener,
ProgressMeter {
    private static final Logger logger = LoggerFactory.getLogger(ActivityExecutor.class);
    private final List<Motor<?>> motors = new ArrayList();
    private final Activity activity;
    private final ActivityDef activityDef;
    private ExecutorService executorService;
    private RuntimeException stoppingException;
    private static final int waitTime = 10000;

    public ActivityExecutor(Activity activity) {
        this.activity = activity;
        this.activityDef = activity.getActivityDef();
        this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new IndexedThreadFactory(activity.getAlias(), new ActivityExceptionHandler(this)));
        activity.getActivityDef().getParams().addListener((ParameterMap.Listener)this);
        activity.setActivityController((ActivityController)this);
    }

    public synchronized void startActivity() {
        logger.info("starting activity " + this.activity.getAlias() + " for cycles " + this.activity.getCycleSummary());
        try {
            this.activity.setRunState(RunState.Starting);
            this.activity.initActivity();
        }
        catch (Exception e) {
            this.stoppingException = new RuntimeException("Error initializing activity '" + this.activity.getAlias() + "': " + e.getMessage(), e);
            logger.error("error initializing activity '" + this.activity.getAlias() + "': " + this.stoppingException);
            throw this.stoppingException;
        }
        this.adjustToActivityDef(this.activity.getActivityDef());
        this.activity.setRunState(RunState.Running);
    }

    public synchronized void stopActivity() {
        this.activity.setRunState(RunState.Stopped);
        logger.info("stopping activity in progress: " + this.getActivityDef().getAlias());
        this.motors.forEach(Stoppable::requestStop);
        this.motors.forEach(m -> this.awaitRequiredMotorState((Motor)m, 30000, 50, RunState.Stopped, RunState.Finished));
        this.activity.shutdownActivity();
        this.activity.closeAutoCloseables();
        logger.info("stopped: " + this.getActivityDef().getAlias() + " with " + this.motors.size() + " slots");
    }

    public synchronized void forceStopExecutor(int initialMillisToWait) {
        this.activity.setRunState(RunState.Stopped);
        this.executorService.shutdown();
        this.requestStopMotors();
        try {
            Thread.sleep(initialMillisToWait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.info("stopping activity forcibly " + this.activity.getAlias());
        List<Runnable> runnables = this.executorService.shutdownNow();
        this.activity.shutdownActivity();
        this.activity.closeAutoCloseables();
        logger.debug(runnables.size() + " threads never started.");
        if (this.stoppingException != null) {
            throw this.stoppingException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestStopExecutor(int secondsToWait) {
        this.activity.setRunState(RunState.Stopped);
        logger.info("Stopping executor for " + this.activity.getAlias() + " when work completes.");
        this.executorService.shutdown();
        boolean wasStopped = false;
        try {
            wasStopped = this.executorService.awaitTermination(secondsToWait, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            wasStopped = false;
            logger.warn("while waiting termination of activity " + this.activity.getAlias() + ", " + ie.getMessage());
        }
        finally {
            this.activity.shutdownActivity();
            this.activity.closeAutoCloseables();
        }
        if (this.stoppingException != null) {
            throw this.stoppingException;
        }
        return wasStopped;
    }

    public synchronized void handleParameterMapUpdate(ParameterMap parameterMap) {
        if (this.activity instanceof ActivityDefObserver) {
            this.activity.onActivityDefUpdate(this.activityDef);
        }
        if (this.activity.getRunState() != RunState.Uninitialized) {
            if (this.activity.getRunState() == RunState.Running) {
                this.adjustToActivityDef(this.activity.getActivityDef());
            }
            this.motors.stream().filter(m -> m instanceof ActivityDefObserver).forEach(m -> ((ActivityDefObserver)m).onActivityDefUpdate(this.activityDef));
        }
    }

    public ActivityDef getActivityDef() {
        return this.activityDef;
    }

    public boolean awaitCompletion(int waitTime) {
        return this.requestStopExecutor(waitTime);
    }

    public boolean awaitFinish(int timeout) {
        boolean awaited = this.awaitAllRequiredMotorState(timeout, 50, RunState.Finished, RunState.Stopped);
        if (awaited) {
            awaited = this.awaitCompletion(timeout);
        }
        if (this.stoppingException != null) {
            throw this.stoppingException;
        }
        return awaited;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "~" + this.activityDef.getAlias();
    }

    private String getSlotStatus() {
        return this.motors.stream().map(m -> m.getSlotStateTracker().getSlotState().getCode()).collect(Collectors.joining(",", "[", "]"));
    }

    private synchronized void adjustToActivityDef(ActivityDef activityDef) {
        Motor motor;
        logger.trace(">-pre-adjust->" + this.getSlotStatus());
        while (this.motors.size() > activityDef.getThreads()) {
            motor = this.motors.get(this.motors.size() - 1);
            logger.trace("Stopping cycle motor thread:" + motor);
            motor.requestStop();
            this.motors.remove(this.motors.size() - 1);
        }
        while (this.motors.size() < activityDef.getThreads()) {
            motor = this.activity.getMotorDispenserDelegate().getMotor(activityDef, this.motors.size());
            logger.trace("Starting cycle motor thread:" + motor);
            this.motors.add(motor);
        }
        this.adjustToIntendedActivityState();
        this.awaitActivityAndMotorStateAlignment();
        logger.trace(">post-adjust->" + this.getSlotStatus());
    }

    private void adjustToIntendedActivityState() {
        logger.trace("ADJUSTING to INTENDED " + this.activity.getRunState());
        switch (this.activity.getRunState()) {
            case Uninitialized: {
                break;
            }
            case Starting: 
            case Running: {
                this.motors.stream().filter(m -> m.getSlotStateTracker().getSlotState() != RunState.Running).filter(m -> m.getSlotStateTracker().getSlotState() != RunState.Finished).forEach(m -> {
                    m.getSlotStateTracker().enterState(RunState.Starting);
                    this.executorService.execute((Runnable)m);
                });
                break;
            }
            case Stopped: {
                this.motors.stream().filter(m -> m.getSlotStateTracker().getSlotState() != RunState.Stopped).forEach(Stoppable::requestStop);
                break;
            }
            case Finished: 
            case Stopping: {
                throw new RuntimeException("Invalid requested state in activity executor:" + this.activity.getRunState());
            }
            default: {
                throw new RuntimeException("Unmatched run state:" + this.activity.getRunState());
            }
        }
    }

    private void awaitActivityAndMotorStateAlignment() {
        switch (this.activity.getRunState()) {
            case Starting: 
            case Running: {
                this.motors.forEach(m -> this.awaitRequiredMotorState((Motor)m, 10000, 50, RunState.Running, RunState.Finished));
                break;
            }
            case Stopped: {
                this.motors.forEach(m -> this.awaitRequiredMotorState((Motor)m, 10000, 50, RunState.Stopped, RunState.Finished));
                break;
            }
            case Uninitialized: {
                break;
            }
            case Finished: {
                this.motors.forEach(m -> this.awaitRequiredMotorState((Motor)m, 10000, 50, RunState.Finished));
                break;
            }
            case Stopping: {
                throw new RuntimeException("Invalid requested state in activity executor:" + this.activity.getRunState());
            }
            default: {
                throw new RuntimeException("Unmatched run state:" + this.activity.getRunState());
            }
        }
    }

    private boolean awaitMotorState(Motor m, int waitTime, int pollTime, RunState ... runState) {
        long startedAt = System.currentTimeMillis();
        while (System.currentTimeMillis() < startedAt + (long)waitTime) {
            for (RunState state : runState) {
                if (m.getSlotStateTracker().getSlotState() != state) continue;
                logger.trace(this.activityDef.getAlias() + "/Motor[" + m.getSlotId() + "] is now in state " + m.getSlotStateTracker().getSlotState());
                return true;
            }
            try {
                Thread.sleep(pollTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.trace(this.activityDef.getAlias() + "/Motor[" + m.getSlotId() + "] is now in state " + m.getSlotStateTracker().getSlotState());
        return false;
    }

    private boolean awaitAllRequiredMotorState(int waitTime, int pollTime, RunState ... awaitingState) {
        long startedAt = System.currentTimeMillis();
        boolean awaited = false;
        block0: while (!awaited && System.currentTimeMillis() < startedAt + (long)waitTime) {
            awaited = true;
            for (Motor<?> motor : this.motors) {
                awaited = this.awaitMotorState(motor, waitTime, pollTime, awaitingState);
                if (awaited) continue;
                logger.trace("failed awaiting motor " + motor.getSlotId() + " for state in " + Arrays.asList(awaitingState));
                continue block0;
            }
        }
        return awaited;
    }

    private boolean awaitAnyRequiredMotorState(int waitTime, int pollTime, RunState ... awaitingState) {
        long startedAt = System.currentTimeMillis();
        while (System.currentTimeMillis() < startedAt + (long)waitTime) {
            for (Motor<?> motor : this.motors) {
                for (RunState state : awaitingState) {
                    if (motor.getSlotStateTracker().getSlotState() != state) continue;
                    logger.trace("at least one 'any' of " + this.activityDef.getAlias() + "/Motor[" + motor.getSlotId() + "] is now in state " + motor.getSlotStateTracker().getSlotState());
                    return true;
                }
            }
            try {
                Thread.sleep(pollTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.trace("none of " + this.activityDef.getAlias() + "/Motor [" + this.motors.size() + "] is in states in " + Arrays.asList(awaitingState));
        return false;
    }

    private void awaitRequiredMotorState(Motor m, int waitTime, int pollTime, RunState ... awaitingState) {
        RunState startingState = m.getSlotStateTracker().getSlotState();
        boolean awaitedRequiredState = this.awaitMotorState(m, waitTime, pollTime, awaitingState);
        if (!awaitedRequiredState) {
            String error = "Unable to await " + this.activityDef.getAlias() + "/Motor[" + m.getSlotId() + "]: from state " + startingState + " to " + m.getSlotStateTracker().getSlotState() + " after waiting for " + waitTime + "ms";
            RuntimeException e = new RuntimeException(error);
            logger.error(error);
            throw e;
        }
        logger.trace("motor " + m + " entered awaited state: " + Arrays.asList(awaitingState));
    }

    private synchronized void requestStopMotors() {
        logger.info("stopping activity " + this.activity);
        this.activity.setRunState(RunState.Stopped);
        this.motors.forEach(Stoppable::requestStop);
    }

    public boolean isRunning() {
        return this.motors.stream().anyMatch(m -> m.getSlotStateTracker().getSlotState() == RunState.Running);
    }

    public Activity getActivity() {
        return this.activity;
    }

    public synchronized double getProgress() {
        ArrayList inputs = this.motors.stream().map(Motor::getInput).distinct().collect(Collectors.toCollection(ArrayList::new));
        double startCycle = this.getActivityDef().getStartCycle();
        double endCycle = this.getActivityDef().getEndCycle();
        double totalCycles = endCycle - startCycle;
        double total = 0.0;
        double progress = 0.0;
        for (Input input : inputs) {
            if (input instanceof ProgressCapable) {
                ProgressCapable progressInput = (ProgressCapable)input;
                total += progressInput.getTotal();
                progress += progressInput.getProgress();
                continue;
            }
            logger.warn("input does not support activity progress: " + input);
            return Double.NaN;
        }
        return progress / total;
    }

    public String getProgressDetails() {
        return this.motors.stream().map(Motor::getInput).distinct().findFirst().filter(i -> i instanceof ProgressCapable).map(i -> ((ProgressCapable)i).getProgressDetails()).orElse("");
    }

    public String getProgressName() {
        return this.activityDef.getAlias();
    }

    public RunState getProgressState() {
        Optional<RunState> first = this.motors.stream().map(Motor::getSlotStateTracker).map(SlotStateTracker::getSlotState).distinct().sorted().findFirst();
        return first.orElse(RunState.Uninitialized);
    }

    public synchronized void notifyException(Thread t, Throwable e) {
        this.stoppingException = new RuntimeException("Error in activity thread " + t.getName(), e);
        this.forceStopExecutor(10000);
    }

    public synchronized void stopActivityWithReasonAsync(String reason) {
        logger.info("Stopping activity " + this.activityDef.getAlias() + ": " + reason);
        this.stoppingException = new RuntimeException("Stopping activity " + this.activityDef.getAlias() + ": " + reason);
        logger.error("stopping with reason: " + this.stoppingException);
        this.requestStopMotors();
    }

    public synchronized void stopActivityWithErrorAsync(Throwable throwable) {
        if (this.stoppingException == null) {
            this.stoppingException = new RuntimeException(throwable);
            logger.error("stopping on error: " + throwable.toString(), throwable);
        } else if (this.activityDef.getParams().getOptionalBoolean("fullerrors").orElse(false).booleanValue()) {
            logger.error("additional error: " + throwable.toString(), throwable);
        } else {
            logger.warn("summarized error (fullerrors=false): " + throwable.toString());
        }
        this.requestStopMotors();
    }
}

