/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import io.engineblock.activityapi.core.Shutdownable;
import io.engineblock.core.ShutdownManager;
import io.engineblock.metrics.ActivityMetrics;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricReporters
implements Shutdownable {
    private static final Logger logger = LoggerFactory.getLogger(MetricReporters.class);
    private static MetricReporters instance = new MetricReporters();
    private List<PrefixedRegistry> metricRegistries = new ArrayList<PrefixedRegistry>();
    private List<ScheduledReporter> scheduledReporters = new ArrayList<ScheduledReporter>();

    private MetricReporters() {
        ShutdownManager.register(this);
    }

    public static MetricReporters getInstance() {
        return instance;
    }

    public MetricReporters addRegistry(String registryPrefix, MetricRegistry metricsRegistry) {
        this.metricRegistries.add(new PrefixedRegistry(registryPrefix, metricsRegistry));
        return this;
    }

    public MetricReporters addGraphite(String dest, String prefix) {
        logger.debug("Adding graphite reporter to " + dest + " with prefix " + prefix);
        if (dest.indexOf(":") >= 0) {
            String[] split = dest.split(":");
            this.addGraphite(split[0], Integer.valueOf(split[1]), prefix);
        } else {
            this.addGraphite(dest, 2003, prefix);
        }
        return this;
    }

    public void addCSVReporter(String directoryName, String prefix) {
        logger.debug("Adding CSV reporter to " + directoryName + " with prefix " + prefix);
        if (this.metricRegistries.isEmpty()) {
            throw new RuntimeException("There are no metric registries.");
        }
        File csvDirectory = new File(directoryName);
        if (!csvDirectory.exists() && !csvDirectory.mkdirs()) {
            throw new RuntimeException("Error creating CSV reporting directory:" + csvDirectory.getAbsolutePath());
        }
        for (PrefixedRegistry prefixedRegistry : this.metricRegistries) {
            CsvReporter csvReporter = CsvReporter.forRegistry((MetricRegistry)prefixedRegistry.metricRegistry).convertDurationsTo(TimeUnit.NANOSECONDS).convertRatesTo(TimeUnit.SECONDS).filter(ActivityMetrics.METRIC_FILTER).formatFor(Locale.US).build(csvDirectory);
            this.scheduledReporters.add((ScheduledReporter)csvReporter);
        }
    }

    public MetricReporters addGraphite(String host, int graphitePort, String prefix) {
        logger.debug("Adding graphite reporter to " + host + " with port " + graphitePort + " and prefix " + prefix);
        if (this.metricRegistries.isEmpty()) {
            throw new RuntimeException("There are no metric registries.");
        }
        for (PrefixedRegistry prefixedRegistry : this.metricRegistries) {
            Graphite graphite = new Graphite(new InetSocketAddress(host, graphitePort));
            GraphiteReporter graphiteReporter = GraphiteReporter.forRegistry((MetricRegistry)prefixedRegistry.metricRegistry).prefixedWith((String)(prefixedRegistry.prefix != null ? (!prefixedRegistry.prefix.isEmpty() ? prefix + "." + prefixedRegistry.prefix : prefix) : prefix)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.NANOSECONDS).filter(ActivityMetrics.METRIC_FILTER).build(graphite);
            this.scheduledReporters.add((ScheduledReporter)graphiteReporter);
        }
        return this;
    }

    public MetricReporters addLogger() {
        logger.debug("Adding slf4j reporter for metrics");
        if (this.metricRegistries.isEmpty()) {
            throw new RuntimeException("There are no metric registries.");
        }
        for (PrefixedRegistry prefixedRegistry : this.metricRegistries) {
            Slf4jReporter loggerReporter = Slf4jReporter.forRegistry((MetricRegistry)prefixedRegistry.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.NANOSECONDS).filter(ActivityMetrics.METRIC_FILTER).outputTo(logger).build();
            this.scheduledReporters.add((ScheduledReporter)loggerReporter);
        }
        return this;
    }

    public MetricReporters start(int consoleIntervalSeconds, int remoteIntervalSeconds) {
        for (ScheduledReporter scheduledReporter : this.scheduledReporters) {
            logger.info("starting reporter: " + scheduledReporter);
            if (scheduledReporter instanceof ConsoleReporter) {
                scheduledReporter.start((long)consoleIntervalSeconds, TimeUnit.SECONDS);
                continue;
            }
            scheduledReporter.start((long)remoteIntervalSeconds, TimeUnit.SECONDS);
        }
        return this;
    }

    public MetricReporters stop() {
        for (ScheduledReporter scheduledReporter : this.scheduledReporters) {
            logger.info("stopping reporter: " + scheduledReporter);
            scheduledReporter.stop();
        }
        return this;
    }

    public MetricReporters report() {
        for (ScheduledReporter scheduledReporter : this.scheduledReporters) {
            logger.info("flushing reporter data: " + scheduledReporter);
            scheduledReporter.report();
        }
        return this;
    }

    public void shutdown() {
        for (ScheduledReporter reporter : this.scheduledReporters) {
            reporter.report();
            reporter.stop();
        }
    }

    private class PrefixedRegistry {
        public String prefix;
        public MetricRegistry metricRegistry;

        public PrefixedRegistry(String prefix, MetricRegistry metricRegistry) {
            this.prefix = prefix;
            this.metricRegistry = metricRegistry;
        }
    }
}

