/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.script;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Snapshot;
import io.engineblock.activityapi.core.Activity;
import io.engineblock.activityapi.core.ActivityType;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.metrics.ActivityMetrics;
import io.engineblock.metrics.MetricRegistryBindings;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsMapper {
    private static final Logger logger = LoggerFactory.getLogger(MetricsMapper.class);
    private static Set<Class<?>> metricsElements = new HashSet<Class<?>>(){
        {
            this.add(Meter.class);
            this.add(Counter.class);
            this.add(Timer.class);
            this.add(Histogram.class);
            this.add(Gauge.class);
            this.add(Snapshot.class);
        }
    };
    private static Predicate<Method> isSimpleGetter = method -> method.getName().startsWith("get") && method.getParameterCount() == 0 && !method.getName().equals("getClass");
    private static Function<Method, String> getPropertyName = method -> {
        String mName = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
        return mName;
    };

    public static String metricsDetail(String activitySpec) {
        ArrayList<CallSite> metricsDetails = new ArrayList<CallSite>();
        ActivityDef activityDef = ActivityDef.parseActivityDef((String)activitySpec);
        logger.info("introspecting metric names for " + activitySpec);
        Optional activityType = ActivityType.FINDER.get(activityDef.getActivityType());
        if (!activityType.isPresent()) {
            throw new RuntimeException("Activity type '" + activityDef.getActivityType() + "' does not exist in this runtime.");
        }
        Activity activity = ((ActivityType)activityType.get()).getAssembledActivity(activityDef, new HashMap());
        MetricRegistryBindings metricRegistryBindings = new MetricRegistryBindings(ActivityMetrics.getMetricRegistry());
        activity.initActivity();
        activity.getInputDispenserDelegate().getInput(0L);
        activity.getActionDispenserDelegate().getAction(0);
        activity.getMotorDispenserDelegate().getMotor(activityDef, 0);
        Map<String, Metric> metricMap = metricRegistryBindings.getMetrics();
        for (Map.Entry<String, Metric> metricEntry : metricMap.entrySet()) {
            String metricName = metricEntry.getKey();
            Metric metricValue = metricEntry.getValue();
            Map<String, String> getterSummary = MetricsMapper.getGetterSummary(metricValue);
            List methodDetails = getterSummary.entrySet().stream().map(es -> metricName + (String)es.getKey() + "  " + (String)es.getValue()).collect(Collectors.toList());
            methodDetails.sort(String::compareTo);
            String getterText = methodDetails.stream().collect(Collectors.joining("\n"));
            metricsDetails.add((CallSite)((Object)(metricName + "\n" + getterText)));
        }
        return metricsDetails.stream().collect(Collectors.joining("\n"));
    }

    private static Map<String, String> getGetterSummary(Object o) {
        return MetricsMapper.getGetterSummary(new HashMap<String, String>(), "", o.getClass());
    }

    private static Map<String, String> getGetterSummary(Map<String, String> accumulator, String name, Class<?> objectType) {
        Arrays.stream(objectType.getMethods()).filter(isSimpleGetter).forEach(m -> {
            if (m.getReturnType().isPrimitive()) {
                accumulator.put(name + "." + getPropertyName.apply((Method)m), m.getReturnType().getSimpleName());
            } else {
                String fullName = name + "." + getPropertyName.apply((Method)m);
                MetricsMapper.getGetterSummary(accumulator, fullName, m.getReturnType());
            }
        });
        return accumulator;
    }
}

