/*
 *
 *    Copyright 2016 jshook
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 * /
 */

package io.engineblock.extensions.csvmetrics;

import com.codahale.metrics.MetricRegistry;
import com.google.auto.service.AutoService;
import io.engineblock.extensions.ScriptingPluginInfo;
import org.slf4j.Logger;

import javax.script.ScriptContext;

@AutoService(ScriptingPluginInfo.class)
public class CSVMetricsPluginData implements ScriptingPluginInfo<CSVMetricsPlugin> {
    @Override
    public String getDescription() {
        return "Allows a script to log some or all metrics to CSV files";
    }

    @Override
    public CSVMetricsPlugin getExtensionObject(Logger logger, MetricRegistry metricRegistry, ScriptContext scriptContext) {
        return new CSVMetricsPlugin(logger, metricRegistry, scriptContext);
    }

    @Override
    public String getBaseVariableName() {
        return "csvmetrics";
    }

}
