/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.common;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor6;

@Beta
public final class MoreElements {
    private static final ElementVisitor<PackageElement, Void> PACKAGE_ELEMENT_VISITOR = new SimpleElementVisitor6<PackageElement, Void>(){

        @Override
        protected PackageElement defaultAction(Element e, Void p) {
            throw new IllegalArgumentException();
        }

        @Override
        public PackageElement visitPackage(PackageElement e, Void p) {
            return e;
        }
    };
    private static final ElementVisitor<TypeElement, Void> TYPE_ELEMENT_VISITOR = new SimpleElementVisitor6<TypeElement, Void>(){

        @Override
        protected TypeElement defaultAction(Element e, Void p) {
            throw new IllegalArgumentException();
        }

        @Override
        public TypeElement visitType(TypeElement e, Void p) {
            return e;
        }
    };
    private static final ElementVisitor<VariableElement, Void> VARIABLE_ELEMENT_VISITOR = new SimpleElementVisitor6<VariableElement, Void>(){

        @Override
        protected VariableElement defaultAction(Element e, Void p) {
            throw new IllegalArgumentException();
        }

        @Override
        public VariableElement visitVariable(VariableElement e, Void p) {
            return e;
        }
    };
    private static final ElementVisitor<ExecutableElement, Void> EXECUTABLE_ELEMENT_VISITOR = new SimpleElementVisitor6<ExecutableElement, Void>(){

        @Override
        protected ExecutableElement defaultAction(Element e, Void p) {
            throw new IllegalArgumentException();
        }

        @Override
        public ExecutableElement visitExecutable(ExecutableElement e, Void p) {
            return e;
        }
    };

    public static PackageElement getPackage(Element element) {
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    public static PackageElement asPackage(Element element) {
        return element.accept(PACKAGE_ELEMENT_VISITOR, null);
    }

    public static TypeElement asType(Element element) {
        return element.accept(TYPE_ELEMENT_VISITOR, null);
    }

    public static VariableElement asVariable(Element element) {
        return element.accept(VARIABLE_ELEMENT_VISITOR, null);
    }

    public static ExecutableElement asExecutable(Element element) {
        return element.accept(EXECUTABLE_ELEMENT_VISITOR, null);
    }

    public static boolean isAnnotationPresent(Element element, Class<? extends Annotation> annotationClass) {
        return MoreElements.getAnnotationMirror(element, annotationClass).isPresent();
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationTypeElement = MoreElements.asType(annotationMirror.getAnnotationType().asElement());
            if (!annotationTypeElement.getQualifiedName().contentEquals(annotationClassName)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.absent();
    }

    private MoreElements() {
    }
}

