/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.VerifyArgument;
import com.strobel.reflection.CallingConvention;
import com.strobel.reflection.GenericType;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.SignatureType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import java.lang.reflect.Method;

final class GenericMethod
extends MethodInfo {
    private final MethodInfo _genericMethodDefinition;
    private final TypeBindings _typeBindings;
    private final ParameterList _parameters;
    private final SignatureType _signatureType;

    GenericMethod(TypeBindings typeBindings, MethodInfo genericMethodDefinition) {
        this._typeBindings = VerifyArgument.notNull(typeBindings, "typeBindings");
        this._genericMethodDefinition = VerifyArgument.notNull(genericMethodDefinition, "genericMethodDefinition");
        ParameterList definitionParameters = this._genericMethodDefinition.getParameters();
        if (definitionParameters.isEmpty()) {
            this._parameters = definitionParameters;
        } else {
            ParameterInfo[] parameters = null;
            int n = definitionParameters.size();
            for (int i = 0; i < n; ++i) {
                ParameterInfo parameter = (ParameterInfo)definitionParameters.get(i);
                Type<?> parameterType = parameter.getParameterType();
                Type resolvedParameterType = this.resolveBindings(parameterType);
                if (resolvedParameterType == parameterType) continue;
                if (parameters == null) {
                    parameters = (ParameterInfo[])definitionParameters.toArray();
                }
                parameters[i] = new ParameterInfo(parameter.getName(), i, this.resolveBindings(parameterType));
            }
            this._parameters = parameters != null ? new ParameterList(parameters) : definitionParameters;
        }
        this._signatureType = new SignatureType(this.resolveBindings(genericMethodDefinition.getReturnType()), this._parameters.getParameterTypes());
    }

    @Override
    protected TypeBindings getTypeBindings() {
        return this._typeBindings;
    }

    @Override
    public MethodInfo getGenericMethodDefinition() {
        return this._genericMethodDefinition;
    }

    @Override
    public Type<?> getReturnType() {
        return this._signatureType.getReturnType();
    }

    @Override
    public SignatureType getSignatureType() {
        return this._signatureType;
    }

    @Override
    public Method getRawMethod() {
        return this._genericMethodDefinition.getRawMethod();
    }

    private Type resolveBindings(Type type) {
        return (Type)GenericType.GenericBinder.visit(type, this._typeBindings);
    }

    @Override
    public String getName() {
        return this._genericMethodDefinition.getName();
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        return this._genericMethodDefinition.appendErasedDescription(sb);
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        return this._genericMethodDefinition.appendErasedSignature(sb);
    }

    @Override
    public Type getDeclaringType() {
        return this._genericMethodDefinition.getDeclaringType();
    }

    @Override
    public ParameterList getParameters() {
        return this._parameters;
    }

    @Override
    public CallingConvention getCallingConvention() {
        return this._genericMethodDefinition.getCallingConvention();
    }

    @Override
    public int getModifiers() {
        return this._genericMethodDefinition.getModifiers();
    }
}

