/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.VerifyArgument;
import com.strobel.reflection.ConstructorInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.SignatureType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import java.lang.reflect.Constructor;

class ReflectedConstructor
extends ConstructorInfo {
    private final Type _declaringType;
    private final ParameterList _parameters;
    private final Constructor _rawConstructor;
    private final TypeList _thrownTypes;
    private final SignatureType _signatureType;

    ReflectedConstructor(Type declaringType, Constructor rawConstructor, ParameterList parameters, TypeList thrownTypes) {
        this._declaringType = VerifyArgument.notNull(declaringType, "declaringType");
        this._rawConstructor = VerifyArgument.notNull(rawConstructor, "rawConstructor");
        this._parameters = VerifyArgument.notNull(parameters, "parameters");
        this._thrownTypes = VerifyArgument.notNull(thrownTypes, "thrownTypes");
        this._signatureType = new SignatureType(PrimitiveTypes.Void, this._parameters.getParameterTypes());
    }

    @Override
    public SignatureType getSignatureType() {
        return this._signatureType;
    }

    @Override
    public ParameterList getParameters() {
        return this._parameters;
    }

    @Override
    public TypeList getThrownTypes() {
        return this._thrownTypes;
    }

    @Override
    public Type getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public Constructor<?> getRawConstructor() {
        return this._rawConstructor;
    }

    @Override
    public int getModifiers() {
        return this._rawConstructor.getModifiers();
    }
}

