/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.reflection.ErasedField;
import com.strobel.reflection.ErasedMethod;
import com.strobel.reflection.ErasedType;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBinder;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import com.strobel.util.TypeUtils;

class TypeEraser
extends TypeBinder {
    TypeEraser() {
    }

    @Override
    public Type<?> visit(Type<?> type) {
        return (Type)this.visit(type, TypeBindings.empty());
    }

    @Override
    public Type<?> visitClassType(Type<?> type, TypeBindings bindings) {
        if (type instanceof ErasedType) {
            return type;
        }
        return type.getErasedType();
    }

    @Override
    public Type<?> visitTypeParameter(Type<?> type, TypeBindings bindings) {
        return this.visit((Type)type.getExtendsBound());
    }

    @Override
    public Type<?> visitWildcardType(Type<?> type, TypeBindings bindings) {
        return this.visit((Type)type.getExtendsBound());
    }

    @Override
    public Type<?> visitArrayType(Type<?> type, TypeBindings bindings) {
        Type<?> oldElementType = type.getElementType();
        Object newElementType = this.visit((Type)oldElementType);
        if (newElementType != oldElementType) {
            return ((Type)newElementType).makeArrayType();
        }
        return type;
    }

    @Override
    public FieldInfo visitField(Type<?> declaringType, FieldInfo field, TypeBindings bindings) {
        Type newFieldType;
        Type<?> oldFieldType = field.getFieldType();
        if (TypeUtils.areEquivalent(oldFieldType, newFieldType = (Type)this.visit(field.getFieldType(), bindings)) && TypeUtils.areEquivalent(field.getDeclaringType(), declaringType)) {
            return field;
        }
        return new ErasedField(field, declaringType, newFieldType);
    }

    @Override
    public MethodInfo visitMethod(Type<?> declaringType, MethodInfo method, TypeBindings bindings) {
        Type<?> oldReturnType = method.getReturnType();
        Type returnType = (Type)this.visit(oldReturnType, bindings);
        ParameterList oldParameters = method.getParameters();
        ParameterList newParameters = this.visitParameters(oldParameters, bindings);
        TypeList oldThrownTypes = method.getThrownTypes();
        Type[] newThrownTypes = new Type[oldThrownTypes.size()];
        boolean hasChanged = !oldReturnType.equals(returnType) || oldParameters != newParameters;
        boolean thrownTypesChanged = false;
        int n = newThrownTypes.length;
        for (int i = 0; i < n; ++i) {
            Type newThrownType;
            Type oldThrownType = (Type)oldThrownTypes.get(i);
            newThrownTypes[i] = newThrownType = (Type)this.visit(oldThrownType, bindings);
            if (oldThrownType.equals(newThrownType)) continue;
            thrownTypesChanged = true;
        }
        if (!(hasChanged |= thrownTypesChanged)) {
            if (!TypeUtils.areEquivalent(method.getDeclaringType(), declaringType)) {
                return MethodInfo.declaredOn(method, declaringType, method.getReflectedType());
            }
            return method;
        }
        return new ErasedMethod(method, declaringType, newParameters, returnType, thrownTypesChanged ? new TypeList(newThrownTypes) : oldThrownTypes, TypeBindings.empty());
    }
}

