/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.common;

import java.util.Arrays;

public final class LongHashSet {
    private Entry[] table;
    private int capacity;
    private int threshold;
    private int size;
    private float loadFactor = 1.3f;

    public LongHashSet() {
        this(16);
    }

    public LongHashSet(int capacity) {
        this.capacity = capacity;
        this.threshold = (int)((float)capacity * this.loadFactor + 0.5f);
        this.table = new Entry[capacity];
    }

    public boolean contains(long key) {
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry entry = this.table[index];
        while (entry != null) {
            if (entry.key == key) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean add(long key) {
        Entry entryOriginal;
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry entry = entryOriginal = this.table[index];
        while (entry != null) {
            if (entry.key == key) {
                return false;
            }
            entry = entry.next;
        }
        this.table[index] = new Entry(key, entryOriginal);
        ++this.size;
        if (this.size > this.threshold) {
            this.setCapacity(2 * this.capacity);
        }
        return true;
    }

    public boolean remove(long key) {
        int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % this.capacity;
        Entry previous = null;
        Entry entry = this.table[index];
        while (entry != null) {
            Entry next = entry.next;
            if (entry.key == key) {
                if (previous == null) {
                    this.table[index] = next;
                } else {
                    previous.next = next;
                }
                --this.size;
                return true;
            }
            previous = entry;
            entry = next;
        }
        return false;
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.table, null);
    }

    public int size() {
        return this.size;
    }

    public void setCapacity(int newCapacity) {
        Entry[] newTable = new Entry[newCapacity];
        for (Entry entry : this.table) {
            while (entry != null) {
                long key = entry.key;
                int index = (((int)(key >>> 32) ^ (int)key) & Integer.MAX_VALUE) % newCapacity;
                Entry originalNext = entry.next;
                entry.next = newTable[index];
                newTable[index] = entry;
                entry = originalNext;
            }
        }
        this.table = newTable;
        this.capacity = newCapacity;
        this.threshold = (int)((float)newCapacity * this.loadFactor + 0.5f);
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        this.loadFactor = loadFactor;
    }

    public void reserveRoom(int entryCount) {
        this.setCapacity((int)((float)entryCount * this.loadFactor * 1.3f + 0.5f));
    }

    static final class Entry {
        final long key;
        Entry next;

        Entry(long key, Entry next) {
            this.key = key;
            this.next = next;
        }
    }
}

